/*
 * Decompiled with CFR 0.152.
 */
package com.lsy.baselib.crypto.util;

import com.lsy.baselib.crypto.exception.StoreUtilException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class StoreUtil {
    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static KeyStore loadFromStore(byte[] data, char[] storePassword, String type, String provider) throws Exception {
        KeyStore store = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
        store.load(new ByteArrayInputStream(data), storePassword);
        return store;
    }

    public static byte[] saveToStore(KeyStore store, char[] password) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        store.store(baos, password);
        return baos.toByteArray();
    }

    public static byte[] create(Certificate[] chain, PrivateKey privatekey, String alias, char[] privatekeyPassword, char[] keystorePassword, String type, String provider) throws Exception {
        KeyStore store = null;
        store = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
        store.load(null, null);
        if (privatekey == null) {
            store.setCertificateEntry(alias, chain[0]);
        } else {
            store.setKeyEntry(alias, privatekey, privatekeyPassword, chain);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        store.store(baos, keystorePassword);
        return baos.toByteArray();
    }

    public static byte[] pfx2jks(byte[] keyStoreData, char[] password, String provider) throws Exception {
        KeyStore oldone = StoreUtil.loadFromStore(keyStoreData, password, "PKCS12", provider);
        KeyStore newone = provider == null ? KeyStore.getInstance("JKS") : KeyStore.getInstance("JKS", provider);
        newone.load(null, null);
        Enumeration<String> e = oldone.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            if (oldone.isCertificateEntry(alias)) {
                newone.setCertificateEntry(alias, oldone.getCertificate(alias));
                continue;
            }
            if (!oldone.isKeyEntry(alias)) continue;
            newone.setKeyEntry(alias, oldone.getKey(alias, password), password, oldone.getCertificateChain(alias));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        newone.store(baos, password);
        return baos.toByteArray();
    }

    public static byte[] jks2pfx(byte[] keyStoreData, char[] password, String provider) throws Exception {
        KeyStore oldone = StoreUtil.loadFromStore(keyStoreData, password, "JKS", provider);
        KeyStore newone = provider == null ? KeyStore.getInstance("PKCS12") : KeyStore.getInstance("PKCS12", provider);
        newone.load(null, null);
        Enumeration<String> e = oldone.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            if (oldone.isCertificateEntry(alias)) {
                newone.setCertificateEntry(alias, oldone.getCertificate(alias));
                continue;
            }
            if (!oldone.isKeyEntry(alias)) continue;
            newone.setKeyEntry(alias, oldone.getKey(alias, password), password, oldone.getCertificateChain(alias));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        newone.store(baos, password);
        return baos.toByteArray();
    }

    public static Key exportPrivatekey(byte[] keyStoreData, char[] storePassword, char[] keyPassword, String type, String alias, String provider) throws StoreUtilException {
        Key key = null;
        try {
            KeyStore keyStore = StoreUtil.loadFromStore(keyStoreData, storePassword, type, provider);
            key = keyStore.getKey(alias, keyPassword);
        }
        catch (Exception e) {
            throw new StoreUtilException("\u5bfc\u51fa\u79c1\u94a5\u5931\u8d25", e);
        }
        return key;
    }

    public static byte[] exportCertificate(byte[] keyStoreData, char[] password, String type, String alias, String provider) throws StoreUtilException {
        byte[] x509CertificateData = null;
        try {
            KeyStore keyStore = StoreUtil.loadFromStore(keyStoreData, password, type, provider);
            Certificate certificate = keyStore.getCertificate(alias);
            x509CertificateData = ((X509Certificate)certificate).getEncoded();
        }
        catch (Exception e) {
            throw new StoreUtilException("\u5bfc\u51fa\u8bc1\u4e66\u5931\u8d25", e);
        }
        return x509CertificateData;
    }
}

