/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle;

import com.dtyunxi.cube.starter.bundle.config.SpringLiquibaseConfiguration;
import com.dtyunxi.huieryun.vo.DataSourceVo;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CubeLiquibaseAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"bundle.liquibase.enable"}, havingValue="true", matchIfMissing=true)
    public SpringLiquibaseConfiguration springLiquibaseConfiguration(@Autowired(required=false) ObjectProvider<DataSourceVo> dataSourceVoObjectProvider, ObjectProvider<DataSource> dataSource) {
        DataSourceVo dataSourceVo = (DataSourceVo)dataSourceVoObjectProvider.getIfAvailable();
        if (dataSourceVo != null) {
            return new SpringLiquibaseConfiguration(dataSourceVo);
        }
        return new SpringLiquibaseConfiguration((DataSource)dataSource.getIfAvailable());
    }

    @Bean
    @ConditionalOnProperty(value={"bundle.liquibase.enable"}, havingValue="true", matchIfMissing=true)
    public SpringLiquibase liquibase(SpringLiquibaseConfiguration springLiquibaseConfiguration) {
        return springLiquibaseConfiguration.createSpringLiquibase();
    }
}

