/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.config;

import com.dtyunxi.cube.starter.bundle.liquibase.BundleSpringLiquibase;
import com.dtyunxi.huieryun.vo.DataSourceVo;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class SpringLiquibaseConfiguration {
    private String url;
    private String user;
    private String password;
    private DataSource dataSource;
    private DataSourceVo dataSourceVo;
    private final LiquibaseProperties properties;

    public SpringLiquibaseConfiguration(DataSourceVo dataSourceVo) {
        this(dataSourceVo, null);
    }

    public SpringLiquibaseConfiguration(DataSource dataSource) {
        this(dataSource, null);
    }

    public SpringLiquibaseConfiguration(DataSource dataSource, LiquibaseProperties properties) {
        this.dataSource = dataSource;
        this.properties = properties;
    }

    public SpringLiquibaseConfiguration(DataSourceVo dataSourceVo, LiquibaseProperties properties) {
        this.dataSourceVo = dataSourceVo;
        this.properties = properties;
    }

    public BundleSpringLiquibase createSpringLiquibase() {
        return this.createSpringLiquibase(this.properties == null ? "classpath:/db/changelog/db.changelog-master.yaml" : this.properties.getChangeLog());
    }

    public BundleSpringLiquibase createSpringLiquibase(String changeLog) {
        BundleSpringLiquibase springLiquibase = new BundleSpringLiquibase();
        if (this.url == null && this.user == null) {
            if (this.dataSource == null) {
                springLiquibase.setDataSource(DataSourceBuilder.create().url(this.dataSourceVo.getJdbcUrl()).username(this.dataSourceVo.getJdbcUserName()).password(this.dataSourceVo.getJdbcUserPassword()).build());
            } else {
                springLiquibase.setDataSource(this.dataSource);
            }
        } else {
            springLiquibase.setDataSource(DataSourceBuilder.create().url(this.url).username(this.user).password(this.password).build());
        }
        springLiquibase.setResourceLoader((ResourceLoader)new DefaultResourceLoader());
        springLiquibase.setChangeLog(changeLog);
        return springLiquibase;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

