/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.mybatis;

import com.alibaba.druid.pool.DruidDataSource;
import com.dtyunxi.cube.starter.mybatis.MyDataSourceProperties;
import com.dtyunxi.huieryun.transaction.DrdsTransactionManager;
import com.github.pagehelper.PageInterceptor;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.logging.slf4j.Slf4jImpl;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.boot.autoconfigure.MybatisProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableTransactionManagement
@EnableConfigurationProperties(value={MyDataSourceProperties.class, MybatisProperties.class})
public class DataSourceConfig {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceConfig.class);
    public static final String TRANSACTION_MANAGER = "dataSourceTransactionManager";
    @Autowired
    MybatisProperties mybatisVo;
    @Autowired
    private MyDataSourceProperties dataSourceVo;
    @Value(value="${druid.stat.mergeSql:true}")
    private boolean mergeSql;

    @Bean(destroyMethod="close")
    public DataSource dataSource() throws SQLException {
        return this.getDataSource();
    }

    protected DataSource getDataSource() throws SQLException {
        logger.debug("Set data source as {}", (Object)this.getDataSourceVo());
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUrl(this.getDataSourceVo().getJdbcUrl());
        dataSource.setUsername(this.getDataSourceVo().getJdbcUserName());
        dataSource.setPassword(this.getDataSourceVo().getJdbcUserPassword());
        dataSource.setInitialSize(this.getDataSourceVo().getInitialSize());
        dataSource.setMaxActive(this.getDataSourceVo().getMaxActive());
        dataSource.setMinIdle(this.getDataSourceVo().getMinIdle());
        dataSource.setMaxWait((long)this.getDataSourceVo().getMaxWait());
        dataSource.setValidationQuery(this.getDataSourceVo().getValidationQuery());
        dataSource.setTestOnBorrow(false);
        dataSource.setTestOnReturn(false);
        dataSource.setTestWhileIdle(true);
        dataSource.setTimeBetweenEvictionRunsMillis(60000L);
        dataSource.setMinEvictableIdleTimeMillis(25200000L);
        dataSource.setRemoveAbandoned(true);
        dataSource.setRemoveAbandonedTimeout(1800);
        dataSource.setLogAbandoned(true);
        dataSource.setFilters("mergeStat");
        dataSource.setConnectionInitSqls((Collection)Lists.newArrayList((Object[])new String[]{"set names utf8mb4;"}));
        if (!this.mergeSql) {
            Properties p = new Properties();
            p.setProperty("druid.stat.mergeSql", this.mergeSql + "");
            dataSource.setConnectProperties(p);
        }
        dataSource.init();
        return dataSource;
    }

    @Bean
    public SqlSessionFactory sqlSessionFactoryBean(DataSource dataSource) throws Exception {
        return this.getSqlSessionFactory(dataSource);
    }

    protected SqlSessionFactory getSqlSessionFactory(DataSource dataSource) throws Exception {
        Configuration config = new Configuration();
        config.setMapUnderscoreToCamelCase(true);
        config.setLogImpl(Slf4jImpl.class);
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource(dataSource);
        sqlSessionFactoryBean.setConfiguration(config);
        PageInterceptor pageInterceptor = new PageInterceptor();
        Properties properties = new Properties();
        properties.setProperty("helperDialect", "mysql");
        pageInterceptor.setProperties(properties);
        sqlSessionFactoryBean.setPlugins(new Interceptor[]{pageInterceptor});
        sqlSessionFactoryBean.setMapperLocations(this.getMybatisVo().resolveMapperLocations());
        if (StringUtils.isNotBlank((CharSequence)this.getMybatisVo().getTypeAliasesPackage())) {
            sqlSessionFactoryBean.setTypeAliasesPackage(this.getMybatisVo().getTypeAliasesPackage());
        }
        return sqlSessionFactoryBean.getObject();
    }

    @Bean(name={"dataSourceTransactionManager"})
    public PlatformTransactionManager dataSourceTransactionManager(DataSource dataSource) {
        return new DrdsTransactionManager(dataSource, this.getDataSourceVo().isDrds());
    }

    public MybatisProperties getMybatisVo() {
        return this.mybatisVo;
    }

    public void setMybatisVo(MybatisProperties mybatisVo) {
        this.mybatisVo = mybatisVo;
    }

    public MyDataSourceProperties getDataSourceVo() {
        return this.dataSourceVo;
    }

    public void setDataSourceVo(MyDataSourceProperties dataSourceVo) {
        this.dataSourceVo = dataSourceVo;
    }
}

