/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.oss;

import com.dtyunxi.app.AppEnv;
import com.dtyunxi.cube.starter.oss.CubeOssAppProperties;
import com.dtyunxi.cube.starter.oss.CubeOssProperties;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.api.ObjectStorageFactory;
import com.dtyunxi.huieryun.oss.constant.OssConstant;
import com.dtyunxi.huieryun.oss.rest.OssPolicyController;
import com.dtyunxi.huieryun.oss.rest.SimpleFileStorageController;
import com.dtyunxi.huieryun.oss.vo.OssAppVo;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@EnableConfigurationProperties(value={CubeOssProperties.class, CubeOssAppProperties.class})
public class CubeOssAutoConfiguration {
    @Autowired
    private OssRegistryVo ossRegistryVo;
    @Autowired
    private OssAppVo ossAppVo;
    @Autowired
    private Environment environment;

    @Bean
    @ConditionalOnMissingBean
    public SimpleFileStorageController simpleFileStorageController() {
        return new SimpleFileStorageController(this.appEnv());
    }

    @Bean
    @ConditionalOnMissingBean
    public OssPolicyController ossPolicyController() {
        return new OssPolicyController(this.environment);
    }

    @Bean
    @ConditionalOnMissingBean
    public IObjectStorageService objectStorageService() {
        return ObjectStorageFactory.createObjectStorage((OssRegistryVo)this.ossRegistryVo);
    }

    @Bean
    public AppEnv appEnv() {
        AppEnv appEnv = new AppEnv();
        OssConstant.registryVo = this.ossRegistryVo;
        OssConstant.APP_ID = this.ossAppVo.getAppId();
        OssConstant.DIR = this.ossAppVo.getDir();
        appEnv.putObject("huieryun.objectstorage.simpleobjectstorage.filehome", (Object)this.ossAppVo.getFileHome());
        return appEnv;
    }
}

