/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework.yira.support;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.app.DeployEnv;
import com.dtyunxi.cube.framework.yira.support.IXmetaApiToEndPointClient;
import com.dtyunxi.cube.framework.yira.support.XmetaApiEnhanceProperties;
import com.dtyunxi.cube.framework.yira.support.XmetaApiEnhancePropertiesResoler;
import feign.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.openfeign.FeignClientFactoryBean;
import org.springframework.cloud.openfeign.OptionsFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"cube.xmeta.enhance.enabled"}, havingValue="true")
@Component(value="xmetaApiToFeignClient")
public class XmetaApiToFeignClientImpl
implements IXmetaApiToEndPointClient {
    protected static final Logger LOG = LoggerFactory.getLogger(XmetaApiToFeignClientImpl.class);
    private Environment environment;
    private ApplicationContext context;
    private XmetaApiEnhancePropertiesResoler xmetaApiEnhancePropertiesResoler;
    private XmetaApiEnhanceProperties enhanceProperties;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void createEndPointClient(Class xMetaApiClass, BeanDefinitionRegistry registry) {
        Class fallbackFactory;
        LOG.info("create FeignClient EndPointClient,ApiClass={}", (Object)xMetaApiClass.getName());
        String className = xMetaApiClass.getName();
        ConfigurableBeanFactory beanFactory = registry instanceof ConfigurableBeanFactory ? (ConfigurableBeanFactory)registry : null;
        String contextId = className.replace('.', '-');
        FeignClientFactoryBean factoryBean = new FeignClientFactoryBean();
        factoryBean.setBeanFactory((BeanFactory)beanFactory);
        String feignApiName = this.xmetaApiEnhancePropertiesResoler.getFeignApiName(xMetaApiClass);
        factoryBean.setName(feignApiName);
        factoryBean.setContextId(contextId);
        factoryBean.setType(xMetaApiClass);
        factoryBean.setRefreshableClient(this.isClientRefreshEnabled());
        String feignApiUrl = this.xmetaApiEnhancePropertiesResoler.getFeignApiUrl(xMetaApiClass);
        factoryBean.setUrl(feignApiUrl);
        String feignApiPath = this.xmetaApiEnhancePropertiesResoler.getFeignApiPath(beanFactory, xMetaApiClass);
        factoryBean.setPath(feignApiPath);
        factoryBean.setDecode404(true);
        Class fallback = this.xmetaApiEnhancePropertiesResoler.getFeignClientFallback(xMetaApiClass);
        if (fallback != null) {
            factoryBean.setFallback(fallback);
        }
        if ((fallbackFactory = this.xmetaApiEnhancePropertiesResoler.getFeignClientFallbackFactory(xMetaApiClass)) != null) {
            factoryBean.setFallbackFactory(fallbackFactory);
        }
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition((Class)xMetaApiClass, () -> factoryBean.getObject());
        definition.setAutowireMode(2);
        definition.setLazyInit(true);
        AbstractBeanDefinition beanDefinition = definition.getBeanDefinition();
        beanDefinition.setAttribute("factoryBeanObjectType", (Object)className);
        beanDefinition.setAttribute("feignClientsRegistrarFactoryBean", (Object)factoryBean);
        beanDefinition.setPrimary(true);
        String[] qualifiers = new String[]{contextId + "FeignClient"};
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, className, qualifiers);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
        LOG.info("register FeignClient bean: {}, targetClass: {}", (Object)holder.getBeanName(), (Object)xMetaApiClass.getName());
        Class[] configurations = this.xmetaApiEnhancePropertiesResoler.getFeignClientConfiguration(xMetaApiClass);
        if (ObjectUtil.isNotEmpty((Object)configurations)) {
            if (StrUtil.isNotBlank((CharSequence)contextId)) {
                this.registerClientConfiguration(registry, contextId, configurations);
            } else {
                this.registerClientConfiguration(registry, feignApiName, configurations);
            }
        }
        this.registerOptionsBeanDefinition(registry, contextId);
    }

    private void registerOptionsBeanDefinition(BeanDefinitionRegistry registry, String contextId) {
        if (this.isClientRefreshEnabled()) {
            String beanName = Request.Options.class.getCanonicalName() + "-" + contextId;
            BeanDefinitionBuilder definitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(OptionsFactoryBean.class);
            definitionBuilder.setScope("refresh");
            definitionBuilder.addPropertyValue("contextId", (Object)contextId);
            BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder((BeanDefinition)definitionBuilder.getBeanDefinition(), beanName);
            definitionHolder = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)registry, (boolean)true);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)registry);
        }
    }

    private void registerClientConfiguration(BeanDefinitionRegistry registry, Object name, Object configuration) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.cloud.openfeign.FeignClientSpecification");
        builder.addConstructorArgValue(name);
        builder.addConstructorArgValue(configuration);
        registry.registerBeanDefinition(name + ".FeignClientSpecification", (BeanDefinition)builder.getBeanDefinition());
    }

    private boolean isClientRefreshEnabled() {
        return (Boolean)this.environment.getProperty("feign.client.refresh-enabled", Boolean.class, (Object)false);
    }

    public void setXmetaApiEnhanceProperties(XmetaApiEnhanceProperties enhanceProperties) {
        this.enhanceProperties = enhanceProperties;
    }

    public void setXmetaApiEnhancePropertiesResoler(XmetaApiEnhancePropertiesResoler xmetaApiEnhancePropertiesResoler) {
        this.xmetaApiEnhancePropertiesResoler = xmetaApiEnhancePropertiesResoler;
    }

    public boolean checkEnable() {
        return DeployEnv.isSpringCloud() && this.enhanceProperties != null && this.enhanceProperties.isFeignClient();
    }
}

