/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.scan.mojo;

import com.dtyunxi.cube.maven.plugin.scan.constant.Constants;
import com.dtyunxi.cube.maven.plugin.scan.dto.ColumnSourceDto;
import com.dtyunxi.cube.maven.plugin.scan.util.ClassUtil;
import com.dtyunxi.cube.maven.plugin.scan.util.FileUtil;
import com.dtyunxi.cube.utils.ReflectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Table;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

@Mojo(name="gen-col-source-json", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.COMPILE)
public class ColumnSourceScanMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> compileClasspathElements;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private String outputDirectory;
    @Parameter(defaultValue="${project.parent.groupId}", readonly=true)
    private String parentGroupId;
    @Parameter(defaultValue="${project.parent.artifactId}", readonly=true)
    private String parentArtifactId;
    @Parameter(defaultValue="${project.version}", readonly=true)
    private String version;
    private URLClassLoader classLoader = Objects.requireNonNull((URLClassLoader)ClassUtils.getDefaultClassLoader(), "\u7c7b\u52a0\u8f7d\u5668\u4e3a\u7a7a");
    private Log log;

    public ColumnSourceScanMojo() {
        this.log = this.getLog();
    }

    public ColumnSourceScanMojo(MavenProject mavenProject, Log log) {
        log.info((CharSequence)"ColumnSourceScanMojo init");
        if (null == this.compileClasspathElements) {
            try {
                this.compileClasspathElements = mavenProject.getCompileClasspathElements();
            }
            catch (DependencyResolutionRequiredException e) {
                throw new RuntimeException("\u83b7\u53d6CompileClasspathElements\u5f02\u5e38", e);
            }
        }
        this.outputDirectory = mavenProject.getBuild().getOutputDirectory();
        this.parentGroupId = mavenProject.getParent().getGroupId();
        this.parentArtifactId = mavenProject.getParent().getArtifactId();
        this.version = mavenProject.getVersion();
        this.log = log;
    }

    public void execute() {
        List<Class> classList = ClassUtil.getAllClasses(this.compileClasspathElements);
        List<Class> eoClassList = classList.stream().filter(c -> null != c.getAnnotation(Table.class)).collect(Collectors.toList());
        Optional<Class> tableRefInfoAnnotation = classList.stream().filter(c -> "com.dtyunxi.annotation.TableRefInfo".equals(c.getCanonicalName())).findAny();
        if (!tableRefInfoAnnotation.isPresent()) {
            return;
        }
        ColumnSourceDto columnSourceDto = this.getSourceDto(eoClassList, tableRefInfoAnnotation.get());
        if (null != columnSourceDto && !CollectionUtils.isEmpty(columnSourceDto.getRefTableMap())) {
            this.log.debug((CharSequence)"\u627e\u5230\u6709\u5173\u8054\u5173\u7cfb\u7684Eo\uff0c\u5f00\u59cb\u5199\u5165json\u6587\u4ef6...");
            FileUtil.writeFile(columnSourceDto, this.outputDirectory, Constants.RESOURCE_EO_REF_TABLE_LOCATION);
        }
    }

    private ColumnSourceDto getSourceDto(List<Class> eoClassList, Class<? extends Annotation> tableRefInfoAnnotation) {
        ColumnSourceDto columnSourceDto = new ColumnSourceDto();
        columnSourceDto.setGroupId(this.parentGroupId);
        columnSourceDto.setArtifactId(this.parentArtifactId);
        columnSourceDto.setVersion(this.version);
        HashMap<String, Map<String, ColumnSourceDto.ColumnSource>> refTableMap = new HashMap<String, Map<String, ColumnSourceDto.ColumnSource>>(128);
        for (Class eoClass : eoClassList) {
            HashMap<String, ColumnSourceDto.ColumnSource> refInfoMap = new HashMap<String, ColumnSourceDto.ColumnSource>(16);
            List fieldList = ReflectUtil.getAllFields((Class)eoClass);
            for (Field field : fieldList) {
                if (!field.isAnnotationPresent(tableRefInfoAnnotation) || !field.isAnnotationPresent(Column.class)) continue;
                Column column = field.getAnnotation(Column.class);
                this.log.debug((CharSequence)(eoClass.getAnnotation(Table.class).name() + " \u8868\u4e2d " + column.name() + " \u5217\u6709RefTable\u6ce8\u89e3"));
                try {
                    refInfoMap.put(column.name(), this.getRefInfo(field.getAnnotation(tableRefInfoAnnotation)));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    this.log.error((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
            if (CollectionUtils.isEmpty(refInfoMap)) continue;
            String entityCode = eoClass.getAnnotation(Table.class).name();
            Map existsRefInfoMap = (Map)refTableMap.get(entityCode);
            if (!CollectionUtils.isEmpty((Map)existsRefInfoMap)) {
                existsRefInfoMap.putAll(refInfoMap);
                continue;
            }
            refTableMap.put(entityCode, refInfoMap);
        }
        columnSourceDto.setRefTableMap(refTableMap);
        return columnSourceDto;
    }

    private ColumnSourceDto.ColumnSource getRefInfo(Object tableRefAnnotationObject) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Class<?> tableAnnotationClass = tableRefAnnotationObject.getClass();
        Method tableNameMethod = tableAnnotationClass.getDeclaredMethod("tableName", new Class[0]);
        Method columnNameMethod = tableAnnotationClass.getDeclaredMethod("columnName", new Class[0]);
        Method displayColNameMethod = tableAnnotationClass.getDeclaredMethod("displayColName", new Class[0]);
        Method dictCategoryNameMethod = tableAnnotationClass.getDeclaredMethod("dictCatalogName", new Class[0]);
        tableNameMethod.setAccessible(true);
        columnNameMethod.setAccessible(true);
        displayColNameMethod.setAccessible(true);
        dictCategoryNameMethod.setAccessible(true);
        Object sourceEntityObject = tableNameMethod.invoke(tableRefAnnotationObject, new Object[0]);
        Object sourceAttrObject = columnNameMethod.invoke(tableRefAnnotationObject, new Object[0]);
        Object sourceDictObject = dictCategoryNameMethod.invoke(tableRefAnnotationObject, new Object[0]);
        Object displayColObject = displayColNameMethod.invoke(tableRefAnnotationObject, new Object[0]);
        String sourceEntity = null;
        String sourceAttr = null;
        String sourceDict = null;
        String sourceDisplayAttr = null;
        if (null != sourceEntityObject && null != sourceAttrObject && null != displayColObject) {
            sourceEntity = (String)sourceEntityObject;
            sourceAttr = (String)sourceAttrObject;
            sourceDisplayAttr = (String)displayColObject;
        } else if (null != sourceDictObject) {
            sourceDict = (String)sourceDictObject;
        } else {
            throw new IllegalArgumentException("TableRefInfo\u6ce8\u89e3\u53c2\u6570\u6709\u8bef!");
        }
        return new ColumnSourceDto.ColumnSource(null, sourceEntity, sourceAttr, sourceDisplayAttr, sourceDict);
    }
}

