/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.scan.util;

import com.dtyunxi.cube.maven.plugin.scan.constant.Constants;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.springframework.core.io.UrlResource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StreamUtils;

public final class ConfigUtils {
    public static void addURLToClassLoad(URLClassLoader classLoader, String classpath) {
        try {
            URL url = new File(classpath).toURI().toURL();
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            boolean accessible = method.isAccessible();
            if (!accessible) {
                method.setAccessible(true);
            }
            method.invoke((Object)classLoader, url);
            method.setAccessible(accessible);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | MalformedURLException e) {
            throw new RuntimeException("URLClassLoader\u8c03\u7528addURL\u51fa\u9519", e);
        }
    }

    public static List<String> loadConfig(ClassLoader classLoader) {
        ArrayList<String> configJsons = new ArrayList<String>();
        try {
            Enumeration<URL> urls;
            Enumeration<URL> enumeration = urls = classLoader != null ? classLoader.getResources(Constants.RESOURCE_LOCATION) : ClassLoader.getSystemResources(Constants.RESOURCE_LOCATION);
            while (urls.hasMoreElements()) {
                UrlResource resource = new UrlResource(urls.nextElement());
                File file = resource.getFile();
                if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
                String configJson = StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
                configJsons.add(configJson);
            }
            return configJsons;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to config from location [" + Constants.RESOURCE_LOCATION + "]", ex);
        }
    }

    public static List<Class<?>> getClasses(int classpathLength, File file, ClassLoader classLoader) {
        ArrayList classes = new ArrayList();
        if (file == null || !file.exists() || !file.isDirectory()) {
            return classes;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    classes.addAll(ConfigUtils.getClasses(classpathLength, f, classLoader));
                    continue;
                }
                if (!f.isFile() || !f.getName().endsWith(".class")) continue;
                String classname = f.getAbsolutePath().substring(classpathLength + 1, f.getAbsolutePath().length() - 6).replaceAll("[/|\\\\]", ".");
                try {
                    classes.add(ClassUtils.forName((String)classname, (ClassLoader)classLoader));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("\u52a0\u8f7d\u7c7b\u5f02\u5e38", e);
                }
            }
        }
        return classes;
    }

    public static Object invoke(Annotation annotation, String methodName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = annotation.getClass().getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        return method.invoke((Object)annotation, new Object[0]);
    }
}

