/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.meta.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.meta.api.IMetaApi;
import com.dtyunxi.yundt.cube.meta.api.query.IEntityQueryApi;
import com.dtyunxi.yundt.cube.meta.api.query.IMetaQueryApi;
import com.dtyunxi.yundt.cube.meta.dto.request.EntityControlledReqDto;
import com.dtyunxi.yundt.cube.meta.dto.request.EntityDto;
import com.dtyunxi.yundt.cube.meta.dto.request.EntityQueryDto;
import com.dtyunxi.yundt.cube.meta.dto.request.MetaFromXzeroDto;
import com.dtyunxi.yundt.cube.meta.dto.request.SourceAttrReqDto;
import com.dtyunxi.yundt.cube.meta.dto.response.SourceAttrRespDto;
import com.github.pagehelper.PageInfo;
import feign.QueryMap;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="metaRest")
@RequestMapping(value={"/v1/meta"})
public class MetaRest
implements IMetaApi,
IMetaQueryApi,
IEntityQueryApi {
    @Resource
    private IMetaQueryApi metaQueryApi;
    @Resource
    private IMetaApi metaApi;
    @Resource
    private IEntityQueryApi entityQueryApi;

    public RestResponse<PageInfo<EntityDto>> queryEntityByPage(@SpringQueryMap EntityDto entityDto, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return this.metaQueryApi.queryEntityByPage(entityDto, pageNum, pageSize);
    }

    public RestResponse<PageInfo<EntityDto>> queryControlledEntityByPage(@SpringQueryMap EntityControlledReqDto entityControlledReqDto, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return this.metaQueryApi.queryControlledEntityByPage(entityControlledReqDto, pageNum, pageSize);
    }

    public RestResponse<PageInfo<EntityDto>> queryEntity(@QueryMap @SpringQueryMap EntityQueryDto entityDto) {
        return this.entityQueryApi.queryEntity(entityDto);
    }

    public RestResponse<EntityDto> queryEntityById(@PathVariable(value="entityId") Long entityId) {
        return this.metaQueryApi.queryEntityById(entityId);
    }

    public RestResponse<EntityDto> queryEntityByCode(@PathVariable(value="entityCode") String entityCode) {
        return this.metaQueryApi.queryEntityByCode(entityCode);
    }

    public RestResponse<Void> addEntity(@RequestBody EntityDto entityDto) {
        return this.metaApi.addEntity(entityDto);
    }

    public RestResponse<Void> modifyEntity(@RequestBody EntityDto entityDto) {
        return this.metaApi.modifyEntity(entityDto);
    }

    public RestResponse<Void> delEntity(@PathVariable(value="entityId") Long entityId) {
        return this.metaApi.delEntity(entityId);
    }

    public RestResponse<List<String>> generateSql(@RequestParam(value="entityIdList") List<Long> entityIdList) {
        return this.metaApi.generateSql(entityIdList);
    }

    public RestResponse<PageInfo<SourceAttrRespDto>> querySourceAttr(@Valid @SpringQueryMap SourceAttrReqDto reqDto, Integer pageNum, Integer pageSize) {
        return this.metaQueryApi.querySourceAttr(reqDto, pageNum, pageSize);
    }

    public RestResponse<Void> controllable(@PathVariable(value="code") String code) {
        return this.metaApi.controllable(code);
    }

    public RestResponse<Void> unControllable(@PathVariable(value="code") String code) {
        return this.metaApi.unControllable(code);
    }

    public RestResponse<Void> calcFactor(@PathVariable(value="id") Long id) {
        return this.metaApi.calcFactor(id);
    }

    public RestResponse<Void> unCalcFactor(@PathVariable(value="id") Long id) {
        return this.metaApi.unCalcFactor(id);
    }

    public RestResponse<Void> syncMetaJsonFromXzero(@RequestBody MetaFromXzeroDto metaFromXzeroDto) {
        return this.metaApi.syncMetaJsonFromXzero(metaFromXzeroDto);
    }
}

