/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.meta.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.meta.constants.AttributeIsCalcFactorEnum;
import com.dtyunxi.yundt.cube.meta.constants.EntityIsControlledEnum;
import com.dtyunxi.yundt.cube.meta.das.AttributeDas;
import com.dtyunxi.yundt.cube.meta.das.EntityDas;
import com.dtyunxi.yundt.cube.meta.das.EntityRelationDas;
import com.dtyunxi.yundt.cube.meta.dto.request.AttributeDto;
import com.dtyunxi.yundt.cube.meta.dto.request.EntityControlledReqDto;
import com.dtyunxi.yundt.cube.meta.dto.request.EntityDto;
import com.dtyunxi.yundt.cube.meta.dto.request.MetaFromXzeroDto;
import com.dtyunxi.yundt.cube.meta.dto.request.SourceAttrReqDto;
import com.dtyunxi.yundt.cube.meta.dto.response.SourceAttrRespDto;
import com.dtyunxi.yundt.cube.meta.eo.AttributeEo;
import com.dtyunxi.yundt.cube.meta.eo.EntityEo;
import com.dtyunxi.yundt.cube.meta.eo.EntityRelationEo;
import com.dtyunxi.yundt.cube.meta.service.IMetaService;
import com.dtyunxi.yundt.cube.meta.vo.SourceAttrQueryVo;
import com.dtyunxi.yundt.cube.meta.vo.SourceAttrVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MetaServiceImpl
implements IMetaService {
    private static final Logger logger = LoggerFactory.getLogger(MetaServiceImpl.class);
    @Resource
    private AttributeDas attributeDas;
    @Resource
    private EntityDas entityDas;
    @Resource
    private ILockService lockService;
    public static final String META_SYNC_LOCK = "MetaSyncLock:";
    @Resource
    private EntityRelationDas entityRelationDas;

    @Override
    public PageInfo<EntityDto> queryEntityByPage(EntityDto entityDto, Integer pageNum, Integer pageSize) {
        EntityEo entityEo = new EntityEo();
        DtoHelper.dto2Eo((BaseVo)entityDto, (BaseEo)entityEo);
        PageInfo eoPageInfo = this.entityDas.selectPage((BaseEo)entityEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<EntityDto> dtoList = new ArrayList<EntityDto>();
        if (CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            for (EntityEo eo : eoPageInfo.getList()) {
                EntityDto dto = new EntityDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
                AttributeEo attributeEo = AttributeEo.newInstance();
                attributeEo.setEntityId(eo.getId());
                List attributeEos = this.attributeDas.select((BaseEo)attributeEo);
                ArrayList attributeDtoList = new ArrayList();
                if (CollectionUtils.isNotEmpty((Collection)attributeEos)) {
                    DtoHelper.eoList2DtoList((Collection)attributeEos, attributeDtoList, AttributeDto.class);
                }
                dto.setAttributeDtoList(attributeDtoList);
                dtoList.add(dto);
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<EntityDto> queryControlledEntityByPage(EntityControlledReqDto entityControlledReqDto, Integer pageNum, Integer pageSize) {
        EntityEo entityEo = new EntityEo();
        entityEo.setIsControlled(EntityIsControlledEnum.Y.getCode());
        DtoHelper.dto2Eo((BaseVo)entityControlledReqDto, (BaseEo)entityEo);
        PageInfo eoPageInfo = this.entityDas.selectPage((BaseEo)entityEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<EntityDto> dtoList = new ArrayList<EntityDto>();
        if (CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            for (EntityEo eo : eoPageInfo.getList()) {
                EntityDto dto = new EntityDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
                AttributeEo attributeEo = AttributeEo.newInstance();
                attributeEo.setEntityId(eo.getId());
                attributeEo.setIsCalcFactor(AttributeIsCalcFactorEnum.Y.getCode());
                List attributeEos = this.attributeDas.select((BaseEo)attributeEo, 1, 1000);
                ArrayList attributeDtoList = new ArrayList();
                if (CollectionUtils.isNotEmpty((Collection)attributeEos)) {
                    DtoHelper.eoList2DtoList((Collection)attributeEos, attributeDtoList, AttributeDto.class);
                }
                dto.setAttributeDtoList(attributeDtoList);
                dtoList.add(dto);
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public EntityDto queryEntityById(Long entityId) {
        EntityEo entityEo = (EntityEo)this.entityDas.selectByPrimaryKey(entityId);
        Assert.isTrue((entityEo != null ? 1 : 0) != 0, (String)"\u6570\u636e\u4e0d\u5b58\u5728");
        AttributeEo attributeEo = AttributeEo.newInstance();
        attributeEo.setEntityId(entityId);
        List attributeEos = this.attributeDas.select((BaseEo)attributeEo);
        ArrayList attributeDtoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)attributeEos)) {
            DtoHelper.eoList2DtoList((Collection)attributeEos, attributeDtoList, AttributeDto.class);
        }
        EntityDto entityDto = new EntityDto();
        DtoHelper.eo2Dto((BaseEo)entityEo, (BaseVo)entityDto);
        entityDto.setAttributeDtoList(attributeDtoList);
        return entityDto;
    }

    @Override
    public EntityDto queryEntityByCode(String entityCode) {
        EntityEo entityEo = this.getEntityEo(entityCode);
        AttributeEo attributeEo = AttributeEo.newInstance();
        attributeEo.setEntityId(entityEo.getId());
        List attributeEos = this.attributeDas.select((BaseEo)attributeEo);
        ArrayList attributeDtoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)attributeEos)) {
            DtoHelper.eoList2DtoList((Collection)attributeEos, attributeDtoList, AttributeDto.class);
        }
        EntityDto entityDto = new EntityDto();
        DtoHelper.eo2Dto((BaseEo)entityEo, (BaseVo)entityDto);
        entityDto.setAttributeDtoList(attributeDtoList);
        return entityDto;
    }

    private EntityEo getEntityEo(String entityCode) {
        EntityEo queryEo = new EntityEo();
        queryEo.setCode(entityCode);
        List entityList = this.entityDas.select((BaseEo)queryEo);
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)entityList), (String)(entityCode + "\u5b9e\u4f53\u6570\u636e\u4e0d\u5b58\u5728"));
        return (EntityEo)((Object)entityList.get(0));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addEntity(EntityDto entityDto) {
        EntityEo entityEo = new EntityEo();
        DtoHelper.dto2Eo((BaseVo)entityDto, (BaseEo)entityEo);
        entityEo.setId(null);
        if (StringUtils.isBlank((CharSequence)entityDto.getExtension())) {
            entityEo.setExtension("");
        }
        this.entityDas.insert((BaseEo)entityEo);
        if (CollectionUtils.isNotEmpty((Collection)entityDto.getAttributeDtoList())) {
            List attributeEos = entityDto.getAttributeDtoList().stream().map(dto -> {
                AttributeEo attributeEo = AttributeEo.newInstance();
                DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)attributeEo);
                attributeEo.setEntityId(entityEo.getId());
                if (StringUtils.isBlank((CharSequence)dto.getExtension())) {
                    attributeEo.setExtension("");
                }
                return attributeEo;
            }).collect(Collectors.toList());
            this.attributeDas.insertBatch(attributeEos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyEntity(EntityDto entityDto) {
        Long entityId = entityDto.getId();
        Assert.isTrue((entityId != null ? 1 : 0) != 0, (String)"id\u4e0d\u80fd\u4e3aNull");
        Assert.isTrue((this.entityDas.selectByPrimaryKey(entityId) != null ? 1 : 0) != 0, (String)"\u6570\u636e\u4e0d\u5b58\u5728");
        EntityEo entityEo = new EntityEo();
        DtoHelper.dto2Eo((BaseVo)entityDto, (BaseEo)entityEo);
        this.entityDas.updateSelective((BaseEo)entityEo);
        if (CollectionUtils.isNotEmpty((Collection)entityDto.getAttributeDtoList())) {
            AttributeEo deleteEo = AttributeEo.newInstance();
            deleteEo.setEntityId(entityId);
            this.attributeDas.delete((BaseEo)deleteEo);
            List attributeEos = entityDto.getAttributeDtoList().stream().map(dto -> {
                AttributeEo attributeEo = AttributeEo.newInstance();
                DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)attributeEo);
                attributeEo.setEntityId(entityEo.getId());
                if (StringUtils.isBlank((CharSequence)dto.getExtension())) {
                    attributeEo.setExtension("");
                }
                return attributeEo;
            }).collect(Collectors.toList());
            this.attributeDas.insertBatch(attributeEos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delEntity(Long entityId) {
        this.entityDas.deleteById(entityId);
        AttributeEo deleteEo = AttributeEo.newInstance();
        deleteEo.setEntityId(entityId);
        this.attributeDas.delete((BaseEo)deleteEo);
    }

    @Override
    public List<String> sqlGenerator(List<Long> entityIdList) {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (Long entityId : entityIdList) {
            EntityEo entityEo = (EntityEo)this.entityDas.selectByPrimaryKey(entityId);
            AttributeEo attributeEo = AttributeEo.newInstance();
            attributeEo.setEntityId(entityId);
            List attributeEoList = this.attributeDas.select((BaseEo)attributeEo);
            if (!CollectionUtils.isNotEmpty((Collection)attributeEoList)) continue;
            String sql = this.generateSql(attributeEoList, entityEo.getCode(), entityEo.getName(), entityEo.getRemark());
            sqlList.add(sql);
        }
        return sqlList;
    }

    private String generateSql(List<AttributeEo> attributeEoList, String tableName, String tableZhName, String remark) {
        ArrayList<String> idxList = new ArrayList<String>();
        StringBuilder sqlSb = new StringBuilder(50);
        sqlSb.append("\r\ndrop table if exists `").append(tableName).append("`;\n");
        sqlSb.append("create table `").append(tableName).append("`(\n");
        for (AttributeEo attributeEo : attributeEoList) {
            sqlSb.append("`").append(attributeEo.getCode()).append("` ");
            if (new Integer(1).equals(attributeEo.getIsPk())) {
                sqlSb.append(attributeEo.getDataType()).append("(").append(attributeEo.getLength()).append(")").append(" NOT NULL AUTO_INCREMENT ").append("COMMENT `").append(attributeEo.getName()).append("`");
                sqlSb.append(",\n ");
                continue;
            }
            sqlSb.append(attributeEo.getDataType());
            if (null != attributeEo.getLength()) {
                sqlSb.append("(").append(attributeEo.getLength()).append(") ");
            }
            if (null != attributeEo.getIsNullable() && !attributeEo.getIsNullable().equals(1)) {
                sqlSb.append("NOT NULL ");
            }
            if (null != attributeEo.getDefaultValue()) {
                sqlSb.append("DEFAULT `").append(attributeEo.getDefaultValue()).append("`");
            }
            if (null != attributeEo.getName()) {
                sqlSb.append(" COMMENT `").append(attributeEo.getName()).append("`");
            }
            if (!new Integer(1).equals(attributeEo.getIsPk()) && new Integer(1).equals(attributeEo.getIsIdx())) {
                idxList.add(attributeEo.getCode());
            }
            sqlSb.append(",\n ");
        }
        sqlSb.append("PRIMARY KEY (`").append(attributeEoList.get(0).getCode()).append("`),");
        if (CollectionUtils.isNotEmpty(idxList)) {
            for (String idx : idxList) {
                sqlSb.append("\n KEY `").append(idx).append("` (`").append(idx).append("`) ").append(",");
            }
        }
        sqlSb.append("`)");
        int lastIndex = sqlSb.lastIndexOf(",");
        String sql = sqlSb.substring(0, lastIndex);
        sql = sql.substring(0, sql.length() - 1) + " \n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT=`" + tableZhName + " " + remark + "`;";
        System.out.println("sql :" + sql);
        return sql;
    }

    @Override
    public PageInfo<SourceAttrRespDto> querySourceAttr(SourceAttrReqDto reqDto, Integer pageNum, Integer pageSize) {
        Assert.notNull((Object)reqDto.getSourceEntity(), (String)"\u503c\u6765\u6e90\u5173\u8054\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)reqDto.getSourceAttr(), (String)"\u503c\u6765\u6e90\u5173\u8054\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)reqDto.getSourceDisplayAttr(), (String)"\u5c55\u793a\u540d\u79f0\u7684\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SourceAttrQueryVo queryVo = new SourceAttrQueryVo();
        CubeBeanUtils.copyProperties((Object)queryVo, (Object)reqDto, (String[])new String[0]);
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getAttrName())) {
            queryVo.setAttrName("'" + reqDto.getAttrName() + "'");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getAttrCodes())) {
            AttributeEo attributeEo = this.queryByCode(reqDto.getSourceEntity(), reqDto.getSourceAttr());
            if (attributeEo != null && attributeEo.getDataType() != null && attributeEo.getDataType().contains("int")) {
                queryVo.setAttrCodes(Arrays.asList(reqDto.getAttrCodes().trim().split(",")));
            } else {
                List<String> attrCodes = Arrays.asList(reqDto.getAttrCodes().trim().split(","));
                queryVo.setAttrCodes(attrCodes.stream().map(code -> "'" + code + "'").collect(Collectors.toList()));
            }
        }
        queryVo.setStart((pageNum - 1) * pageSize);
        queryVo.setPageSize(pageSize);
        List<SourceAttrVo> voList = this.attributeDas.querySourceAttr(queryVo);
        PageInfo dtoPageInfo = new PageInfo();
        if (CollectionUtils.isNotEmpty(voList)) {
            long total = this.attributeDas.querySourceAttrCount(queryVo);
            ArrayList list = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)list, voList, SourceAttrRespDto.class);
            dtoPageInfo.setList((List)list);
            dtoPageInfo.setPageNum(pageNum.intValue());
            dtoPageInfo.setPageSize(pageSize.intValue());
            dtoPageInfo.setSize(voList.size());
            dtoPageInfo.setPages(Long.valueOf(total / (long)pageSize.intValue() + (long)(total % (long)pageSize.intValue() == 0L ? 0 : 1)).intValue());
            dtoPageInfo.setTotal(total);
            dtoPageInfo.setStartRow((long)((pageNum - 1) * pageSize + 1));
            dtoPageInfo.setEndRow((long)((pageNum - 1) * pageSize + voList.size()));
        }
        return dtoPageInfo;
    }

    @Override
    public AttributeEo queryByCode(String entityCode, String attributeCode) {
        EntityEo queryEo = new EntityEo();
        queryEo.setCode(entityCode);
        EntityEo entityEo = (EntityEo)this.entityDas.selectOne((BaseEo)queryEo);
        if (entityEo != null) {
            AttributeEo eo = new AttributeEo();
            eo.setEntityId(entityEo.getId());
            eo.setCode(attributeCode);
            return (AttributeEo)this.attributeDas.selectOne((BaseEo)eo);
        }
        return null;
    }

    @Override
    public void controllable(String code) {
        this.setIsControlled(code, EntityIsControlledEnum.Y);
    }

    private void setIsControlled(String code, EntityIsControlledEnum y) {
        EntityEo entityEo = this.getEntityEo(code);
        if (!y.getCode().equals(entityEo.getIsControlled())) {
            entityEo.setIsControlled(y.getCode());
            this.entityDas.updateSelective((BaseEo)entityEo);
        }
    }

    @Override
    public void unControllable(String code) {
        this.setIsControlled(code, EntityIsControlledEnum.N);
    }

    @Override
    public void calcFactor(Long id) {
        this.setIsCalcFactorEnum(id, AttributeIsCalcFactorEnum.Y);
    }

    private void setIsCalcFactorEnum(Long id, AttributeIsCalcFactorEnum y) {
        AttributeEo attributeEo = (AttributeEo)this.attributeDas.selectByPrimaryKey(id);
        Assert.notNull((Object)((Object)attributeEo), (String)"\u5c5e\u6027\u6570\u636e\u4e0d\u5b58\u5728");
        if (!y.getCode().equals(attributeEo.getIsCalcFactor())) {
            attributeEo.setIsCalcFactor(y.getCode());
            this.attributeDas.updateSelective((BaseEo)attributeEo);
        }
    }

    @Override
    public void unCalcFactor(Long id) {
        this.setIsCalcFactorEnum(id, AttributeIsCalcFactorEnum.N);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncMetaJsonFromXzero(MetaFromXzeroDto metaFromXzeroDto) {
        if (metaFromXzeroDto == null) {
            return;
        }
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock(META_SYNC_LOCK, "1", 30, 600, TimeUnit.SECONDS);
            this.processMetaSync(metaFromXzeroDto);
            if (mutex == null) return;
        }
        catch (BusinessRuntimeException bre) {
            try {
                throw new BizException("\u83b7\u53d6\u4e0d\u5230\u9501\u5f02\u5e38:" + bre.getMessage());
            }
            catch (Throwable throwable) {
                if (mutex == null) throw throwable;
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
        return;
    }

    private void processMetaSync(MetaFromXzeroDto metaFromXzeroDto) {
        List entities = metaFromXzeroDto.getEntities();
        List relations = metaFromXzeroDto.getRelations();
        if (CollectionUtils.isEmpty((Collection)entities) && CollectionUtils.isEmpty((Collection)relations)) {
            logger.info("\u65e0\u5143\u6570\u636e\u5b9e\u4f53\u9700\u8981\u66f4\u65b0");
            return;
        }
        try {
            if (CollectionUtils.isNotEmpty((Collection)entities)) {
                for (MetaFromXzeroDto.MetaEntity entityDto : entities) {
                    Long entityId;
                    EntityEo queryEntityEo = new EntityEo();
                    queryEntityEo.setCode(entityDto.getCode());
                    List entityEos = this.entityDas.select((BaseEo)queryEntityEo, 1, 1);
                    if (entityDto.isNeedDrop()) {
                        if (CollectionUtils.isEmpty((Collection)entityEos)) continue;
                        entityId = ((EntityEo)((Object)entityEos.get(0))).getId();
                        this.entityDas.logicDeleteById(entityId);
                        AttributeEo queryAttrEo = new AttributeEo();
                        queryAttrEo.setEntityId(entityId);
                        List deleteAttrEos = this.attributeDas.select((BaseEo)queryAttrEo, 1, 1000);
                        Iterator iterator = deleteAttrEos.iterator();
                        while (iterator.hasNext()) {
                            AttributeEo attr = (AttributeEo)((Object)iterator.next());
                            this.attributeDas.logicDelete((BaseEo)attr);
                        }
                        continue;
                    }
                    if (CollectionUtils.isEmpty((Collection)entityEos)) {
                        EntityEo insertEntityEo = new EntityEo();
                        CubeBeanUtils.copyProperties((Object)((Object)insertEntityEo), (Object)entityDto, (String[])new String[0]);
                        this.entityDas.insert((BaseEo)insertEntityEo);
                        List attrs = entityDto.getAttrs();
                        for (MetaFromXzeroDto.MetaAttr attr : attrs) {
                            AttributeEo insertAttrEo = new AttributeEo();
                            CubeBeanUtils.copyProperties((Object)((Object)insertAttrEo), (Object)attr, (String[])new String[0]);
                            insertAttrEo.setEntityId(insertEntityEo.getId());
                            this.attributeDas.insert((BaseEo)insertAttrEo);
                        }
                        continue;
                    }
                    entityId = ((EntityEo)((Object)entityEos.get(0))).getId();
                    EntityEo updateEntityEo = new EntityEo();
                    CubeBeanUtils.copyProperties((Object)((Object)updateEntityEo), (Object)entityDto, (String[])new String[0]);
                    updateEntityEo.setId(entityId);
                    this.entityDas.updateSelective((BaseEo)updateEntityEo);
                    AttributeEo queryAttrEo = new AttributeEo();
                    queryAttrEo.setEntityId(entityId);
                    List dbAttrs = this.attributeDas.select((BaseEo)queryAttrEo, 1, 1000);
                    if (CollectionUtils.isEmpty((Collection)dbAttrs)) {
                        for (MetaFromXzeroDto.MetaAttr attr : entityDto.getAttrs()) {
                            AttributeEo insertAttrEo = new AttributeEo();
                            CubeBeanUtils.copyProperties((Object)((Object)insertAttrEo), (Object)attr, (String[])new String[0]);
                            insertAttrEo.setEntityId(entityId);
                            this.attributeDas.insert((BaseEo)insertAttrEo);
                        }
                        continue;
                    }
                    Map<String, Long> attrCode2Eo = dbAttrs.stream().collect(Collectors.toMap(item -> item.getCode().toLowerCase(), BaseEo::getId, (k1, k2) -> k1));
                    for (MetaFromXzeroDto.MetaAttr attr : entityDto.getAttrs()) {
                        Long attrId;
                        if (attr.isNeedDrop()) {
                            attrId = attrCode2Eo.get(attr.getCode().toLowerCase());
                            if (attrId == null) continue;
                            this.attributeDas.logicDeleteById(attrId);
                            continue;
                        }
                        attrId = attrCode2Eo.get(attr.getCode().toLowerCase());
                        if (attrId == null) {
                            AttributeEo insertAttrEo = new AttributeEo();
                            CubeBeanUtils.copyProperties((Object)((Object)insertAttrEo), (Object)attr, (String[])new String[0]);
                            insertAttrEo.setEntityId(entityId);
                            this.attributeDas.insert((BaseEo)insertAttrEo);
                            continue;
                        }
                        AttributeEo updateAttrEo = new AttributeEo();
                        CubeBeanUtils.copyProperties((Object)((Object)updateAttrEo), (Object)attr, (String[])new String[0]);
                        updateAttrEo.setEntityId(entityId);
                        updateAttrEo.setId(attrId);
                        this.attributeDas.updateSelective((BaseEo)updateAttrEo);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)relations)) {
                for (MetaFromXzeroDto.EntityRelation relation : relations) {
                    EntityRelationEo queryRelationEo = new EntityRelationEo();
                    queryRelationEo.setEntityCodeA(relation.getEntityCodeA());
                    queryRelationEo.setAttrCodeA(relation.getAttrCodeA());
                    queryRelationEo.setEntityCodeB(relation.getEntityCodeB());
                    queryRelationEo.setAttrCodeB(relation.getAttrCodeB());
                    List relationEos = this.entityRelationDas.select((BaseEo)queryRelationEo, 1, 1);
                    if (relation.isNeedDrop()) {
                        if (CollectionUtils.isEmpty((Collection)relationEos)) continue;
                        this.entityRelationDas.logicDeleteById(((EntityRelationEo)((Object)relationEos.get(0))).getId());
                        continue;
                    }
                    if (CollectionUtils.isEmpty((Collection)relationEos)) {
                        EntityRelationEo insertRelationEo = new EntityRelationEo();
                        CubeBeanUtils.copyProperties((Object)((Object)insertRelationEo), (Object)relation, (String[])new String[0]);
                        this.entityRelationDas.insert((BaseEo)insertRelationEo);
                        continue;
                    }
                    Long relationId = ((EntityRelationEo)((Object)relationEos.get(0))).getId();
                    EntityRelationEo updateRelationEo = new EntityRelationEo();
                    CubeBeanUtils.copyProperties((Object)((Object)updateRelationEo), (Object)relation, (String[])new String[0]);
                    updateRelationEo.setId(relationId);
                    this.entityRelationDas.updateSelective((BaseEo)updateRelationEo);
                }
            }
        }
        catch (BadSqlGrammarException e) {
            logger.error("\u540c\u6b65\u5143\u6570\u636e\u9519\u8bef:{}", (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5143\u6570\u636e\u9519\u8bef:{}", (Object)e.getMessage());
        }
    }
}

