/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.meta.support;

import com.dtyunxi.yundt.cube.meta.vo2.ColumnVo;
import com.dtyunxi.yundt.cube.meta.vo2.TableGroupVo;
import com.dtyunxi.yundt.cube.meta.vo2.TableVo;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class DataScriptProcessor {
    private TableVo tableVo = null;
    private TableGroupVo tableGroup = null;
    private List<List<Object>> tableData = new ArrayList<List<Object>>();
    Map<String, List<String>> mapReferenceKey = new HashMap<String, List<String>>();

    public DataScriptProcessor(TableVo tableVo, TableGroupVo tableGroup) {
        this.tableVo = tableVo;
        this.tableGroup = tableGroup;
        int pkColumnIndex = tableVo.getPrimaryKeyIndex();
        if (pkColumnIndex == -1) {
            System.out.println("Table: " + tableVo.getTableName() + " has no primary key column\r\n");
        }
        this.mapReferenceKey.put(tableVo.getPrimaryKeys()[0], new ArrayList());
        if (tableGroup.referenceKeys != null) {
            StringTokenizer st = new StringTokenizer(tableGroup.referenceKeys, ",");
            while (st.hasMoreTokens()) {
                this.mapReferenceKey.put(st.nextToken(), new ArrayList());
            }
        }
    }

    public Object processResultSet(ResultSet rs) throws Exception {
        Object colValueObj = null;
        while (rs.next()) {
            ArrayList<Object> listRow = new ArrayList<Object>();
            for (ColumnVo columnVo : this.tableVo.getColumns()) {
                colValueObj = null;
                colValueObj = ColumnVo.isString(columnVo.getDataType()) ? rs.getString(columnVo.getColumnName()) : (ColumnVo.isBlob(columnVo.getDataType()) ? (Object)rs.getBytes(columnVo.getColumnName()) : (-7 == columnVo.getDataType() ? Integer.valueOf(rs.getInt(columnVo.getColumnName())) : rs.getObject(columnVo.getColumnName())));
                String column = columnVo.getColumnName().toLowerCase();
                if (this.mapReferenceKey.containsKey(column)) {
                    this.mapReferenceKey.get(column).add(colValueObj.toString());
                }
                listRow.add(colValueObj);
            }
            this.tableData.add(listRow);
        }
        return this.getPrimaryValues();
    }

    public List<String> getPrimaryValues() {
        return this.getValues(this.tableVo.getPrimaryKeys()[0]);
    }

    public List<String> getValues(String referenceKey) {
        ArrayList<String> values = new ArrayList<String>();
        List<String> duplicatedValues = this.mapReferenceKey.get(referenceKey);
        HashSet<String> setValues = new HashSet<String>();
        for (String value : duplicatedValues) {
            if (setValues.contains(value)) continue;
            values.add(value);
            setValues.add(value);
        }
        return values;
    }

    public List<String> getInsertSql() throws Exception {
        Object objColValue = null;
        String strColValue = null;
        String strColValueTemp = null;
        String rowData = null;
        ArrayList<String> listSql = new ArrayList<String>();
        for (List<Object> listRow : this.tableData) {
            rowData = "";
            for (int i = 0; i < listRow.size(); ++i) {
                ColumnVo columnVo = this.tableVo.getColumns()[i];
                objColValue = listRow.get(i);
                strColValue = null;
                if (objColValue != null) {
                    if (ColumnVo.isNumber(columnVo.getDataType())) {
                        strColValue = objColValue.toString().trim();
                    } else if (ColumnVo.isBlob(columnVo.getDataType())) {
                        strColValue = "null";
                    } else {
                        strColValueTemp = objColValue.toString().trim();
                        if (strColValueTemp.equalsIgnoreCase("null")) {
                            strColValue = "null";
                        } else {
                            strColValueTemp = strColValueTemp.replace("'", "''");
                            strColValueTemp = strColValueTemp.replace("\\", "\\\\");
                            strColValueTemp = strColValueTemp.replace("\"", "\\\"");
                            strColValue = "'" + strColValueTemp + "'";
                        }
                    }
                } else if (this.tableVo.getColumns()[i].isNullAllowed()) {
                    strColValue = "null";
                } else {
                    StringBuffer sb = new StringBuffer();
                    sb.append("\u8868\u540d\uff1a" + this.tableVo.getTableName() + ",");
                    sb.append("\u5217\u540d: " + columnVo.getColumnName() + " \u4e0d\u5141\u8bb8\u4e3a\u7a7a");
                    throw new Exception(sb.toString());
                }
                rowData = rowData + " " + strColValue + ",";
            }
            rowData = rowData.substring(0, rowData.length() - 1);
            rowData = this.getInsertSqlColumn(this.tableVo) + rowData + ")";
            listSql.add(rowData);
        }
        return listSql;
    }

    public String getInsertSqlColumn(TableVo tableVo) {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO " + tableVo.getTableName() + "(");
        for (int i = 0; i < tableVo.getColumns().length; ++i) {
            if (i < tableVo.getColumns().length - 1) {
                sb.append(tableVo.getColumns()[i].getColumnName().toLowerCase() + ",");
                continue;
            }
            sb.append(tableVo.getColumns()[i].getColumnName().toLowerCase());
        }
        sb.append(") VALUES(");
        return sb.toString();
    }
}

