/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.meta.support.db;

import com.dtyunxi.yundt.cube.meta.support.db.DbUtil;
import com.dtyunxi.yundt.cube.meta.support.db.IDatabase;
import com.dtyunxi.yundt.cube.meta.vo2.ColumnVo;
import com.dtyunxi.yundt.cube.meta.vo2.TableDataVo;
import com.dtyunxi.yundt.cube.meta.vo2.TableVo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTableNames(Connection conn, IDatabase database, String tablePrefix) throws Exception {
        String[] stringArray;
        String[] tableNames = null;
        ResultSet rs = null;
        try {
            ArrayList<String> listTableName = new ArrayList<String>();
            DatabaseMetaData dbmd = conn.getMetaData();
            String tableNamePattern = "%";
            if (tablePrefix != null) {
                tableNamePattern = tablePrefix + "%";
            }
            String[] tableTypes = new String[]{"TABLE"};
            String tt = conn.getCatalog();
            String aa = conn.getSchema();
            rs = dbmd.getTables(conn.getCatalog(), conn.getSchema(), database.getTableName(tableNamePattern), tableTypes);
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                listTableName.add(name);
            }
            if (listTableName.size() > 0) {
                tableNames = new String[listTableName.size()];
                listTableName.toArray(tableNames);
            }
            stringArray = tableNames;
        }
        catch (Throwable throwable) {
            DbUtil.closeQuitely(rs);
            throw throwable;
        }
        DbUtil.closeQuitely(rs);
        return stringArray;
    }

    private String[] getPrimaryKeys(ResultSet resultSetPk) throws Exception {
        ArrayList<String> listPk = new ArrayList<String>();
        while (resultSetPk.next()) {
            listPk.add(resultSetPk.getString("COLUMN_NAME"));
        }
        if (listPk.size() <= 0) {
            listPk.add("id");
        }
        String[] pks = new String[listPk.size()];
        listPk.toArray(pks);
        return pks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableVo getTable(Connection conn, IDatabase database, String tableName) throws Exception {
        TableVo tableVo;
        TableVo table = new TableVo(tableName);
        ResultSet resultSetPk = null;
        ResultSet resultSetCol = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            resultSetPk = dbmd.getPrimaryKeys(conn.getCatalog(), null, database.getTableName(tableName));
            table.setPrimaryKeys(this.getPrimaryKeys(resultSetPk));
            resultSetCol = dbmd.getColumns(conn.getCatalog(), null, database.getTableName(tableName), "%");
            ArrayList<ColumnVo> listColumn = new ArrayList<ColumnVo>();
            while (resultSetCol.next()) {
                resultSetCol.getString("TABLE_CAT");
                resultSetCol.getString("TABLE_SCHEM");
                resultSetCol.getString("TABLE_NAME");
                String columnName = resultSetCol.getString("COLUMN_NAME");
                short dataType = resultSetCol.getShort("DATA_TYPE");
                String typeName = resultSetCol.getString("TYPE_NAME");
                int columnSize = resultSetCol.getInt("COLUMN_SIZE");
                resultSetCol.getInt("DECIMAL_DIGITS");
                resultSetCol.getInt("NUM_PREC_RADIX");
                resultSetCol.getInt("NULLABLE");
                String remarks = resultSetCol.getString("REMARKS");
                String columnDef = null;
                try {
                    columnDef = new String(resultSetCol.getBytes("COLUMN_DEF"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                resultSetCol.getInt("SQL_DATA_TYPE");
                resultSetCol.getInt("SQL_DATETIME_SUB");
                resultSetCol.getInt("CHAR_OCTET_LENGTH");
                int ordinalPosition = resultSetCol.getInt("ORDINAL_POSITION");
                String isNullable = resultSetCol.getString("IS_NULLABLE");
                ColumnVo columnVo = new ColumnVo();
                columnVo.setColumnName(columnName);
                columnVo.setMaxLength(columnSize);
                columnVo.setDataType(dataType);
                columnVo.setDataTypeName(typeName);
                columnVo.setNote(remarks);
                columnVo.setIndex(ordinalPosition);
                if (isNullable.equals("YES")) {
                    columnVo.setNullAllowed(true);
                } else {
                    columnVo.setNullAllowed(false);
                }
                listColumn.add(columnVo);
            }
            if (listColumn.size() > 0) {
                ColumnVo[] columnVos = new ColumnVo[listColumn.size()];
                listColumn.toArray(columnVos);
                table.setColumns(columnVos);
            }
            tableVo = table;
        }
        catch (Throwable throwable) {
            DbUtil.closeQuitely(resultSetPk);
            DbUtil.closeQuitely(resultSetCol);
            throw throwable;
        }
        DbUtil.closeQuitely(resultSetPk);
        DbUtil.closeQuitely(resultSetCol);
        return tableVo;
    }

    public static String getTableDataQuery(TableVo tableVo, String whereClause, String tableWhereCond) {
        String selectString = "select ";
        for (int i = 0; i < tableVo.getColumns().length; ++i) {
            selectString = selectString + tableVo.getColumns()[i].getColumnName() + ", ";
        }
        selectString = selectString.substring(0, selectString.length() - 2);
        selectString = selectString + " from " + tableVo.getTableName();
        if (whereClause != null) {
            selectString = selectString + " where ( " + whereClause + " )";
        }
        if (tableWhereCond != null) {
            selectString = whereClause == null ? selectString + " where ( " + tableWhereCond + " )" : selectString + " and ( " + tableWhereCond + " )";
        }
        return selectString;
    }

    public static String getTableDataQuery(TableVo tableVo, String whereClause, String tableWhereCond, String limit) {
        String selectString = "select ";
        for (int i = 0; i < tableVo.getColumns().length; ++i) {
            selectString = selectString + tableVo.getColumns()[i].getColumnName() + ", ";
        }
        selectString = selectString.substring(0, selectString.length() - 2);
        selectString = selectString + " from " + tableVo.getTableName();
        if (whereClause != null) {
            selectString = selectString + " where ( " + whereClause + " )";
        }
        if (tableWhereCond != null) {
            selectString = whereClause == null ? selectString + " where ( " + tableWhereCond + " )" : selectString + " and ( " + tableWhereCond + " )";
        }
        if (limit != null) {
            selectString = selectString + " " + limit;
        }
        return selectString;
    }

    public static String getCountQuery(TableVo tableVo, String whereClause, String tableWhereCond) {
        String selectString = "select count(1) as total ";
        selectString = selectString + " from " + tableVo.getTableName();
        if (whereClause != null) {
            selectString = selectString + " where ( " + whereClause + " )";
        }
        if (tableWhereCond != null) {
            selectString = whereClause == null ? selectString + " where ( " + tableWhereCond + " )" : selectString + " and ( " + tableWhereCond + " )";
        }
        return selectString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalCount(Connection conn, TableVo tableVo, String whereCondition) throws Exception {
        int totalCount = 0;
        Statement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = conn.createStatement();
            String countQuery = TableDao.getCountQuery(tableVo, whereCondition, null);
            resultSet = stmt.executeQuery(countQuery);
            while (resultSet.next()) {
                totalCount = resultSet.getInt("total");
            }
        }
        catch (Throwable throwable) {
            DbUtil.closeQuitely(resultSet);
            DbUtil.closeQuitely(stmt);
            throw throwable;
        }
        DbUtil.closeQuitely(resultSet);
        DbUtil.closeQuitely(stmt);
        return totalCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableDataVo getTableData(Connection conn, TableVo tableVo, String whereCondition, String limit) throws Exception {
        TableDataVo tableDataVo;
        TableDataVo tableDataVo2 = new TableDataVo();
        tableDataVo2.tableVo = tableVo;
        tableDataVo2.data = new ArrayList<List<Object>>();
        tableDataVo2.dataMapList = new ArrayList<Map<String, Object>>();
        tableDataVo2.dataIdList = new ArrayList<Long>();
        Statement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = conn.createStatement();
            tableDataVo2.totalCount = this.getTotalCount(conn, tableVo, whereCondition);
            String tableDataQuery = TableDao.getTableDataQuery(tableVo, whereCondition, null, limit);
            resultSet = stmt.executeQuery(tableDataQuery);
            int tatalLineCount = 0;
            while (resultSet.next()) {
                ArrayList<String> columnData = new ArrayList<String>();
                HashMap<String, String> dataMap = new HashMap<String, String>();
                Long dataId = null;
                for (ColumnVo column : tableVo.getColumns()) {
                    Object colValueObj = null;
                    colValueObj = ColumnVo.isString(column.getDataType()) ? resultSet.getString(column.getColumnName()) : resultSet.getObject(column.getColumnName());
                    String colValue = "null";
                    if (colValueObj != null) {
                        colValue = colValueObj.toString().trim();
                    }
                    columnData.add(colValue);
                    dataMap.put(column.getColumnName(), colValue);
                    if (!"id".equalsIgnoreCase(column.getColumnName())) continue;
                    dataId = Long.parseLong("" + colValue);
                }
                tableDataVo2.data.add(columnData);
                tableDataVo2.dataMapList.add(dataMap);
                tableDataVo2.dataIdList.add(dataId);
                ++tatalLineCount;
            }
            tableDataVo = tableDataVo2;
        }
        catch (Throwable throwable) {
            DbUtil.closeQuitely(resultSet);
            DbUtil.closeQuitely(stmt);
            throw throwable;
        }
        DbUtil.closeQuitely(resultSet);
        DbUtil.closeQuitely(stmt);
        return tableDataVo;
    }
}

