/**
 * @(#)${className}ServiceImpl.java 1.0 ${generateTime}
 *
 * Copyright (c) ${generateYear}, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ${packageName}.biz.service.impl;

import org.springframework.stereotype.Service;
import ${packageName}.biz.service.I${className}Service;
import com.github.pagehelper.PageInfo;
import ${packageName}.dao.das.${className}Das;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import javax.annotation.Resource;
import ${packageName}.api.dto.request.${className}AddReqDto;
import ${packageName}.api.dto.request.${className}ModifyReqDto;
import ${packageName}.api.dto.request.${className}QueryReqDto;
import ${packageName}.dao.eo.${className}Eo;
import org.springframework.transaction.annotation.Transactional;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import java.util.ArrayList;
import java.util.List;

/**
* ${tableComment}服务实现类
*
* @author 代码生成器
* @Date : ${generateTime}
*/
@Service
public class ${className}ServiceImpl implements I${className}Service {

    @Resource
    private ${className}Das ${resourceName}Das;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long add(${className}AddReqDto addReqDto) {
        ${className}Eo ${resourceName}Eo = new ${className}Eo();
        DtoHelper.dto2Eo(addReqDto, ${resourceName}Eo);
        ${resourceName}Das.insert(${resourceName}Eo);
        return ${resourceName}Eo.getId();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void modify(${className}ModifyReqDto modifyReqDto) {
        ${className}Eo ${resourceName}Eo = new ${className}Eo();
        DtoHelper.dto2Eo(modifyReqDto, ${resourceName}Eo);
        ${resourceName}Das.updateSelective(${resourceName}Eo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void remove(Long id) {
        ${resourceName}Das.logicDeleteById(id);
    }

    @Override
    public ${className}RespDto queryById(Long id) {
        ${className}Eo ${resourceName}Eo = ${resourceName}Das.selectByPrimaryKey(id);
        ${className}RespDto ${resourceName}RespDto = new ${className}RespDto();
        DtoHelper.eo2Dto(${resourceName}Eo, ${resourceName}RespDto);
        return ${resourceName}RespDto;
    }

    @Override
    public PageInfo<${className}RespDto> queryByPage(${className}ReqDto queryReqDto,
                                                     Integer pageNum,
                                                     Integer pageSize) {

        ${className}Eo ${resourceName}Eo = new ${className}Eo();
        DtoHelper.dto2Eo(queryReqDto, ${resourceName}Eo);
        PageInfo<${className}Eo> eoPageInfo = ${resourceName}Das.selectPage(${resourceName}Eo, pageNum, pageSize);

        PageInfo<${className}RespDto> dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties(dtoPageInfo, eoPageInfo, "list", "navigatepageNums");
        List<${className}RespDto> dtoList = new ArrayList<>();
        DtoHelper.eoList2DtoList(eoPageInfo.getList(), dtoList, ${className}RespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

}
