/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.dao.query;

import com.dtyunxi.huieryun.dao.query.QueryExpressionToken;
import com.dtyunxi.huieryun.dao.query.QueryExpressionTokenParser;
import com.dtyunxi.huieryun.dao.query.QueryRelationType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class QueryExpression {
    public String expression;
    public QueryRelationType queryRelationType;
    public List<QueryExpression> nodes = new ArrayList<QueryExpression>();

    QueryExpression() {
        this.queryRelationType = QueryRelationType.AND;
    }

    public static List<QueryExpression> parse(String queryString) {
        try {
            if (StringUtils.isEmpty((CharSequence)queryString)) {
                return new ArrayList<QueryExpression>();
            }
            List<QueryExpression> expressions = QueryExpression.parseExpression(queryString);
            QueryExpression.checkIsSameRelationType(expressions);
            return expressions;
        }
        catch (Exception ex) {
            throw new RuntimeException(MessageFormat.format("Invalid query expression, QueryString: {0}, reason: {1}", queryString, ex.getMessage()));
        }
    }

    private static List<QueryExpression> parseExpression(String queryString) {
        ArrayList<QueryExpression> root = new ArrayList<QueryExpression>();
        List<QueryExpressionToken> queryExpressionTokens = new QueryExpressionTokenParser().parse(queryString);
        List<String> tokenList = QueryExpression.convert(queryExpressionTokens);
        ArrayList<ArrayList<QueryExpression>> parentsNodes = new ArrayList<ArrayList<QueryExpression>>();
        List<QueryExpression> currentNodes = root;
        Iterator<String> iterator = tokenList.iterator();
        block12: while (iterator.hasNext()) {
            String token;
            switch (token = iterator.next()) {
                case "OPEN": {
                    QueryExpression openNode = new QueryExpression();
                    currentNodes.add(openNode);
                    parentsNodes.add((ArrayList<QueryExpression>)currentNodes);
                    currentNodes = openNode.nodes;
                    continue block12;
                }
                case "CLOSE": {
                    if (parentsNodes.size() > 0) {
                        currentNodes = (List)parentsNodes.get(parentsNodes.size() - 1);
                        parentsNodes.remove(parentsNodes.size() - 1);
                        continue block12;
                    }
                    throw new RuntimeException("Error closing bracket.");
                }
                case "AND": {
                    if (currentNodes.size() > 0) {
                        ((QueryExpression)currentNodes.get((int)(currentNodes.size() - 1))).queryRelationType = QueryRelationType.AND;
                        continue block12;
                    }
                    throw new RuntimeException("Error AND relation.");
                }
                case "OR": {
                    if (currentNodes.size() > 0) {
                        ((QueryExpression)currentNodes.get((int)(currentNodes.size() - 1))).queryRelationType = QueryRelationType.OR;
                        continue block12;
                    }
                    throw new RuntimeException("Error OR relation.");
                }
            }
            QueryExpression stringNode = new QueryExpression();
            stringNode.expression = token;
            currentNodes.add(stringNode);
        }
        if (parentsNodes.size() != 0) {
            throw new RuntimeException("Error closing bracket.");
        }
        return root;
    }

    private static List<String> convert(List<QueryExpressionToken> source) {
        ArrayList<String> list = new ArrayList<String>();
        boolean lastTokenIsWord = false;
        for (QueryExpressionToken token : source) {
            if (!token.getToken().equals((Object)QueryExpressionToken.Token.WORD)) {
                list.add(token.getLiteral());
                lastTokenIsWord = false;
                continue;
            }
            if (lastTokenIsWord) {
                list.set(list.size() - 1, (String)list.get(list.size() - 1) + " " + token.getLiteral());
                continue;
            }
            list.add(token.getLiteral());
            lastTokenIsWord = true;
        }
        return list;
    }

    private static void checkIsSameRelationType(List<QueryExpression> expressions) {
        String relation = null;
        for (int i = 0; i < expressions.size(); ++i) {
            QueryExpression expression = expressions.get(i);
            if (expression.nodes.size() > 0) {
                QueryExpression.checkIsSameRelationType(expression.nodes);
            }
            String tmpRelation = expression.queryRelationType.name();
            if (relation == null) {
                relation = tmpRelation;
                continue;
            }
            if (i >= expressions.size() - 1 || relation.equals(tmpRelation)) continue;
            throw new RuntimeException("Relation(AND/OR) must be same in single expression node.");
        }
    }
}

