/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.dao.query;

import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class QueryInfo {
    private Pageable pageable;
    private String expression;
    private String fields;
    private int scrollSize;
    private boolean checkOperator;

    public QueryInfo() {
        this.checkOperator = false;
    }

    public QueryInfo(Pageable pageable, String expression) {
        this.pageable = pageable;
        this.expression = expression;
    }

    public static QueryInfo from(String expression, Object ... arguments) {
        return QueryInfo.from((Pageable)PageRequest.of((int)0, (int)20), expression, arguments);
    }

    public static QueryInfo from(int page, int size, String expression, Object ... arguments) {
        return QueryInfo.from((Pageable)PageRequest.of((int)page, (int)size), expression, arguments);
    }

    public static QueryInfo from(Pageable pageable, String expression, Object ... arguments) {
        String expressionFormat = null;
        if (!org.springframework.util.StringUtils.isEmpty((Object)expression)) {
            for (int i = 0; i < arguments.length; ++i) {
                Object object = arguments[i];
                if (!(object instanceof Number)) continue;
                arguments[i] = object.toString();
            }
            expressionFormat = MessageFormat.format(expression, arguments);
        }
        return new QueryInfo(pageable, expressionFormat);
    }

    public String[] getFieldArray() {
        if (org.springframework.util.StringUtils.isEmpty((Object)this.fields)) {
            return null;
        }
        return StringUtils.split((String)this.fields, (String)",");
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Pageable getPageable() {
        return this.pageable;
    }

    public void setPageable(Pageable pageable) {
        this.pageable = pageable;
    }

    public String getFields() {
        return this.fields;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public int getScrollSize() {
        return this.scrollSize;
    }

    public void setScrollSize(int scrollSize) {
        this.scrollSize = scrollSize;
    }

    public boolean getCheckOperator() {
        return this.checkOperator;
    }

    public void setCheckOperator(boolean checkOperator) {
        this.checkOperator = checkOperator;
    }
}

