/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd;

import com.coreos.jetcd.EtcdClient;
import com.coreos.jetcd.exception.AuthFailedException;
import com.coreos.jetcd.exception.ConnectException;
import com.coreos.jetcd.resolver.AbstractEtcdNameResolverFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.util.List;

public class EtcdClientBuilder {
    private List<String> endpoints = Lists.newArrayList();
    private ByteString name;
    private ByteString password;
    private AbstractEtcdNameResolverFactory nameResolverFactory;

    private EtcdClientBuilder() {
    }

    public static EtcdClientBuilder newBuilder() {
        return new EtcdClientBuilder();
    }

    public List<String> endpoints() {
        return this.endpoints;
    }

    public EtcdClientBuilder endpoints(String ... endpoints) {
        Preconditions.checkNotNull((Object)endpoints, (Object)"endpoints can't be null");
        Preconditions.checkArgument((endpoints.length > 0 ? 1 : 0) != 0, (Object)"please configure at lease one endpoint ");
        for (String endpoint : endpoints) {
            Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint can't be null");
            String trimmedEndpoint = endpoint.trim();
            Preconditions.checkArgument((trimmedEndpoint.length() > 0 ? 1 : 0) != 0, (Object)("invalid endpoint: endpoint=" + endpoint));
            this.endpoints.add(trimmedEndpoint);
        }
        return this;
    }

    public ByteString getName() {
        return this.name;
    }

    public EtcdClientBuilder setName(ByteString name) {
        Preconditions.checkNotNull((Object)name, (Object)"name can't be null");
        this.name = name;
        return this;
    }

    public ByteString getPassword() {
        return this.password;
    }

    public EtcdClientBuilder setPassword(ByteString password) {
        Preconditions.checkNotNull((Object)this.name, (Object)"password can't be null");
        this.password = password;
        return this;
    }

    public EtcdClientBuilder setNameResolverFactory(AbstractEtcdNameResolverFactory nameResolverFactory) {
        Preconditions.checkNotNull((Object)((Object)nameResolverFactory));
        this.nameResolverFactory = nameResolverFactory;
        return this;
    }

    public AbstractEtcdNameResolverFactory getNameResolverFactory() {
        return this.nameResolverFactory;
    }

    public EtcdClient build() throws ConnectException, AuthFailedException {
        Preconditions.checkState((!this.endpoints.isEmpty() || this.nameResolverFactory != null ? 1 : 0) != 0, (Object)"please configure ectd serve endpoints or nameResolverFactory before build.");
        return new EtcdClient(null, this);
    }
}

