/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd;

import com.coreos.jetcd.EtcdLease;
import com.coreos.jetcd.api.LeaseGrantRequest;
import com.coreos.jetcd.api.LeaseGrantResponse;
import com.coreos.jetcd.api.LeaseGrpc;
import com.coreos.jetcd.api.LeaseKeepAliveRequest;
import com.coreos.jetcd.api.LeaseKeepAliveResponse;
import com.coreos.jetcd.api.LeaseRevokeRequest;
import com.coreos.jetcd.api.LeaseRevokeResponse;
import com.coreos.jetcd.lease.Lease;
import com.coreos.jetcd.lease.NoSuchLeaseException;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class EtcdLeaseImpl
implements EtcdLease {
    private static final int DEFAULT_TTL = 5000;
    private static final int DEFAULT_SCAN_PERIOD = 500;
    private final LeaseGrpc.LeaseFutureStub leaseFutureStub;
    private final LeaseGrpc.LeaseStub leaseStub;
    private ManagedChannel channel;
    private ScheduledExecutorService keepAliveSchedule;
    private ScheduledFuture<?> scheduledFuture;
    private long scanPeriod;
    private Map<Long, Lease> keepAlives = new ConcurrentHashMap<Long, Lease>();
    private long firstKeepAliveTimeOut = 5000L;
    private StreamObserver<LeaseKeepAliveRequest> keepAliveRequestStreamObserver;
    private StreamObserver<LeaseKeepAliveResponse> keepAliveResponseStreamObserver;

    public EtcdLeaseImpl(ManagedChannel channel) {
        this.channel = channel;
        this.leaseFutureStub = LeaseGrpc.newFutureStub((Channel)this.channel);
        this.leaseStub = LeaseGrpc.newStub((Channel)this.channel);
        this.scanPeriod = 500L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startKeepAliveService() {
        EtcdLeaseImpl etcdLeaseImpl = this;
        synchronized (etcdLeaseImpl) {
            if (this.isKeepAliveServiceRunning()) {
                throw new IllegalStateException("Lease keep alive service already start");
            }
            this.keepAliveResponseStreamObserver = new StreamObserver<LeaseKeepAliveResponse>(){

                public void onNext(LeaseKeepAliveResponse leaseKeepAliveResponse) {
                    EtcdLeaseImpl.this.processKeepAliveRespond(leaseKeepAliveResponse);
                    Lease lease = (Lease)EtcdLeaseImpl.this.keepAlives.get(leaseKeepAliveResponse.getID());
                    if (lease != null && lease.isContainHandler()) {
                        lease.getEtcdLeaseHandler().onKeepAliveRespond(leaseKeepAliveResponse);
                    }
                }

                public void onError(Throwable throwable) {
                }

                public void onCompleted() {
                }
            };
            this.initRequestStream(this.keepAliveResponseStreamObserver);
            if (this.keepAliveSchedule == null) {
                this.keepAliveSchedule = Executors.newSingleThreadScheduledExecutor();
            }
            this.scheduledFuture = this.keepAliveSchedule.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    EtcdLeaseImpl.this.keepAliveExecutor();
                    EtcdLeaseImpl.this.deadLineExecutor();
                }
            }, 0L, this.scanPeriod, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isKeepAliveServiceRunning() {
        EtcdLeaseImpl etcdLeaseImpl = this;
        synchronized (etcdLeaseImpl) {
            return this.scheduledFuture != null && !this.scheduledFuture.isCancelled();
        }
    }

    @Override
    public ListenableFuture<LeaseGrantResponse> grant(long ttl) {
        LeaseGrantRequest leaseGrantRequest = LeaseGrantRequest.newBuilder().setTTL(ttl).build();
        return this.leaseFutureStub.leaseGrant(leaseGrantRequest);
    }

    @Override
    public ListenableFuture<LeaseRevokeResponse> revoke(long leaseId) {
        LeaseRevokeRequest leaseRevokeRequest = LeaseRevokeRequest.newBuilder().setID(leaseId).build();
        return this.leaseFutureStub.leaseRevoke(leaseRevokeRequest);
    }

    @Override
    public synchronized void keepAlive(long leaseId, EtcdLease.EtcdLeaseHandler etcdLeaseHandler) {
        if (!this.keepAlives.containsKey(leaseId)) {
            Lease lease = new Lease(leaseId, etcdLeaseHandler);
            long now = System.currentTimeMillis();
            lease.setNextKeepAlive(now).setDeadLine(now + this.firstKeepAliveTimeOut);
            this.keepAlives.put(leaseId, lease);
        }
    }

    @Override
    public ListenableFuture<LeaseKeepAliveResponse> keepAliveOnce(long leaseId) {
        StreamObserver<LeaseKeepAliveRequest> requestObserver = this.leaseStub.leaseKeepAlive(this.keepAliveResponseStreamObserver);
        requestObserver.onNext((Object)this.newKeepAliveRequest(leaseId));
        requestObserver.onCompleted();
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEtcdLeaseHandler(long leaseId, EtcdLease.EtcdLeaseHandler etcdLeaseHandler) throws NoSuchLeaseException {
        Lease lease = this.keepAlives.get(leaseId);
        if (lease != null) {
            Lease lease2 = lease;
            synchronized (lease2) {
                lease.setEtcdLeaseHandler(etcdLeaseHandler);
            }
        } else {
            throw new NoSuchLeaseException(leaseId);
        }
    }

    private void keepAliveExecutor() {
        long now = System.currentTimeMillis();
        ArrayList<Long> toSendIds = new ArrayList<Long>();
        for (Lease l : this.keepAlives.values()) {
            if (now <= l.getNextKeepAlive()) continue;
            toSendIds.add(l.getLeaseID());
        }
        for (Long id : toSendIds) {
            this.keepAliveRequestStreamObserver.onNext((Object)this.newKeepAliveRequest(id));
        }
    }

    private void deadLineExecutor() {
        long now = System.currentTimeMillis();
        ArrayList<Long> expireLeases = new ArrayList<Long>();
        for (Lease l : this.keepAlives.values()) {
            if (now <= l.getDeadLine()) continue;
            expireLeases.add(l.getLeaseID());
        }
        for (Long id : expireLeases) {
            Lease lease = this.keepAlives.get(id);
            if (lease != null && lease.isContainHandler()) {
                lease.getEtcdLeaseHandler().onLeaseExpired(id);
            }
            this.removeLease(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processKeepAliveRespond(LeaseKeepAliveResponse leaseKeepAliveResponse) {
        long id = leaseKeepAliveResponse.getID();
        Lease lease = this.keepAlives.get(id);
        if (lease != null) {
            Lease lease2 = lease;
            synchronized (lease2) {
                if (leaseKeepAliveResponse.getTTL() <= 0L) {
                    if (lease != null && lease.isContainHandler()) {
                        lease.getEtcdLeaseHandler().onLeaseExpired(id);
                    }
                    this.removeLease(id);
                } else {
                    long nextKeepAlive = System.currentTimeMillis() + 1000L + leaseKeepAliveResponse.getTTL() * 1000L / 3L;
                    lease.setNextKeepAlive(nextKeepAlive);
                    lease.setDeadLine(System.currentTimeMillis() + leaseKeepAliveResponse.getTTL() * 1000L);
                }
            }
        }
    }

    private void removeLease(long leaseId) {
        if (this.keepAlives.containsKey(leaseId)) {
            this.keepAlives.remove(leaseId);
        }
    }

    private LeaseKeepAliveRequest newKeepAliveRequest(long leaseId) {
        return LeaseKeepAliveRequest.newBuilder().setID(leaseId).build();
    }

    private void initRequestStream(StreamObserver<LeaseKeepAliveResponse> leaseKeepAliveResponseStreamObserver) {
        if (this.keepAliveRequestStreamObserver != null) {
            this.keepAliveRequestStreamObserver.onCompleted();
        }
        this.keepAliveRequestStreamObserver = this.leaseStub.leaseKeepAlive(leaseKeepAliveResponseStreamObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeKeepAliveService() {
        EtcdLeaseImpl etcdLeaseImpl = this;
        synchronized (etcdLeaseImpl) {
            if (this.scheduledFuture == null) {
                throw new IllegalStateException("Lease keep alive service not start yet");
            }
            this.keepAliveRequestStreamObserver.onCompleted();
            this.keepAliveRequestStreamObserver = null;
            this.keepAliveResponseStreamObserver = null;
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
    }
}

