/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.options;

import com.google.common.base.Optional;
import com.google.protobuf.ByteString;

public final class DeleteOption {
    public static final DeleteOption DEFAULT = DeleteOption.newBuilder().build();
    private final Optional<ByteString> endKey;
    private final boolean prevKV;

    public static Builder newBuilder() {
        return new Builder();
    }

    private DeleteOption(Optional<ByteString> endKey, boolean prevKV) {
        this.endKey = endKey;
        this.prevKV = prevKV;
    }

    public Optional<ByteString> getEndKey() {
        return this.endKey;
    }

    public boolean isPrevKV() {
        return this.prevKV;
    }

    public static class Builder {
        private Optional<ByteString> endKey = Optional.absent();
        private boolean prevKV = false;

        private Builder() {
        }

        public Builder withRange(ByteString endKey) {
            this.endKey = Optional.fromNullable((Object)endKey);
            return this;
        }

        public Builder withPrevKV(boolean prevKV) {
            this.prevKV = prevKV;
            return this;
        }

        public DeleteOption build() {
            return new DeleteOption(this.endKey, this.prevKV);
        }
    }
}

