/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.options;

import com.coreos.jetcd.api.RangeRequest;
import com.coreos.jetcd.options.Optional;
import com.google.protobuf.ByteString;

public final class GetOption {
    public static final GetOption DEFAULT = GetOption.newBuilder().build();
    private final Optional<ByteString> endKey;
    private final long limit;
    private final long revision;
    private final RangeRequest.SortOrder sortOrder;
    private final RangeRequest.SortTarget sortTarget;
    private final boolean serializable;
    private final boolean keysOnly;
    private final boolean countOnly;

    public static Builder newBuilder() {
        return new Builder();
    }

    private GetOption(Optional<ByteString> endKey, long limit, long revision, RangeRequest.SortOrder sortOrder, RangeRequest.SortTarget sortTarget, boolean serializable, boolean keysOnly, boolean countOnly) {
        this.endKey = endKey;
        this.limit = limit;
        this.revision = revision;
        this.sortOrder = sortOrder;
        this.sortTarget = sortTarget;
        this.serializable = serializable;
        this.keysOnly = keysOnly;
        this.countOnly = countOnly;
    }

    public long getLimit() {
        return this.limit;
    }

    public Optional<ByteString> getEndKey() {
        return this.endKey;
    }

    public long getRevision() {
        return this.revision;
    }

    public RangeRequest.SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public RangeRequest.SortTarget getSortField() {
        return this.sortTarget;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public boolean isKeysOnly() {
        return this.keysOnly;
    }

    public boolean isCountOnly() {
        return this.countOnly;
    }

    public static class Builder {
        private long limit = 0L;
        private long revision = 0L;
        private RangeRequest.SortOrder sortOrder = RangeRequest.SortOrder.NONE;
        private RangeRequest.SortTarget sortTarget = RangeRequest.SortTarget.KEY;
        private boolean serializable = false;
        private boolean keysOnly = false;
        private boolean countOnly = false;
        private Optional<ByteString> endKey = Optional.empty();

        private Builder() {
        }

        public Builder withLimit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder withRevision(long revision) {
            this.revision = revision;
            return this;
        }

        public Builder withSortOrder(RangeRequest.SortOrder order) {
            this.sortOrder = order;
            return this;
        }

        public Builder withSortField(RangeRequest.SortTarget field) {
            this.sortTarget = field;
            return this;
        }

        public Builder withSerializable(boolean serializable) {
            this.serializable = serializable;
            return this;
        }

        public Builder withKeysOnly(boolean keysOnly) {
            this.keysOnly = keysOnly;
            return this;
        }

        public Builder withCountOnly(boolean countOnly) {
            this.countOnly = countOnly;
            return this;
        }

        public Builder withRange(ByteString endKey) {
            this.endKey = Optional.ofNullable(endKey);
            return this;
        }

        public GetOption build() {
            return new GetOption(this.endKey, this.limit, this.revision, this.sortOrder, this.sortTarget, this.serializable, this.keysOnly, this.countOnly);
        }
    }
}

