/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.resolver;

import com.coreos.jetcd.resolver.AbstractEtcdNameResolverFactory;
import com.coreos.jetcd.resolver.DnsSrvNameResolver;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.NameResolver;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;

public class DnsSrvNameResolverFactory
extends AbstractEtcdNameResolverFactory {
    private static final String SCHEME = "dns+srv";
    private static final String NAME = "dns+srv";

    @Nullable
    public NameResolver newNameResolver(URI targetUri, Attributes params) {
        if ("dns+srv".equals(targetUri.getScheme())) {
            String targetPath = (String)Preconditions.checkNotNull((Object)targetUri.getPath(), (Object)"targetPath");
            Preconditions.checkArgument((boolean)targetPath.startsWith("/"), (String)"the path component (%s) of the target (%s) must start with '/'", (Object[])new Object[]{targetPath, targetUri});
            String name = targetPath.substring(1);
            if (!name.startsWith("_etcd-server._tcp.")) {
                name = "_etcd-server._tcp." + name;
            }
            return new DnsSrvNameResolver(name, (SharedResourceHolder.Resource<ExecutorService>)GrpcUtil.SHARED_CHANNEL_EXECUTOR);
        }
        return null;
    }

    public String getDefaultScheme() {
        return "dns+srv";
    }

    @Override
    public String name() {
        return "dns+srv";
    }
}

