/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.resolver;

import com.coreos.jetcd.resolver.AbstractEtcdNameResolverFactory;
import com.coreos.jetcd.resolver.SimpleEtcdNameResolver;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.NameResolver;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;

public class SimpleEtcdNameResolverFactory
extends AbstractEtcdNameResolverFactory {
    private static final String SCHEME = "etcd";
    private static final String NAME = "simple";
    private final URI[] uris;

    public SimpleEtcdNameResolverFactory(URI ... uris) {
        this.uris = uris;
    }

    @Nullable
    public NameResolver newNameResolver(URI targetUri, Attributes params) {
        if (SCHEME.equals(targetUri.getScheme())) {
            String targetPath = (String)Preconditions.checkNotNull((Object)targetUri.getPath(), (Object)"targetPath");
            Preconditions.checkArgument((boolean)targetPath.startsWith("/"), (String)"the path component (%s) of the target (%s) must start with '/'", (Object[])new Object[]{targetPath, targetUri});
            String name = targetPath.substring(1);
            return new SimpleEtcdNameResolver(name, (SharedResourceHolder.Resource<ExecutorService>)GrpcUtil.SHARED_CHANNEL_EXECUTOR, this.uris);
        }
        return null;
    }

    public String getDefaultScheme() {
        return SCHEME;
    }

    @Override
    public String name() {
        return NAME;
    }
}

