/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.log;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.log.LogConstants;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.huieryun.log.RequestId;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=1)
@Deprecated
public class LogHandler
implements LogConstants {
    private static final Logger logger = LoggerFactory.getLogger(LogHandler.class);

    @Around(value="!execution(* com.dtyunxi..config.*.*(..)) && execution(* com.dtyunxi.yundt..*.*(..))")
    public Object logAround(ProceedingJoinPoint joinPoint) throws Throwable {
        String methodName = joinPoint.getSignature().getDeclaringTypeName() + "." + joinPoint.getSignature().getName();
        String requestId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        if (requestId == null) {
            requestId = RequestId.createReqId();
            ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        }
        MDC.put((String)"yes.req.requestId", (String)requestId);
        Object obj = null;
        Long startTime = System.currentTimeMillis();
        obj = joinPoint.proceed();
        Long endTime = System.currentTimeMillis();
        Long elapsedTime = endTime - startTime;
        MDC.put((String)"elapsedTime", (String)elapsedTime.toString());
        MDC.put((String)"handlerMethod", (String)methodName);
        MDC.remove((String)"elapsedTime");
        MDC.remove((String)"handlerMethod");
        return obj;
    }
}

