/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.log.aop;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.log.LoggerFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;

public abstract class AbstractApiLogAspect {
    private static Logger logger = LoggerFactory.getLogger(AbstractApiLogAspect.class);

    public abstract void apiLogAop();

    @Around(value="apiLogAop()")
    public Object aroundApi(ProceedingJoinPoint point) throws Throwable {
        return this.log(point);
    }

    private Object log(ProceedingJoinPoint point) throws Throwable {
        logger.info("\u65e5\u5fd7\u7edf\u4e00\u6253\u5370 ===== {}.{}() start =====,\u53c2\u6570:{}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), this.argsToString(point.getArgs())});
        DateTime startTime = new DateTime();
        DateTime endTime = null;
        Interval interval = null;
        Object response = null;
        try {
            response = point.proceed();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            endTime = new DateTime();
            interval = new Interval((ReadableInstant)startTime, (ReadableInstant)endTime);
            logger.info("\u65e5\u5fd7\u7edf\u4e00\u6253\u5370 ===== {}.{}() end =====,\u54cd\u5e94\u65f6\u95f4:{}\u6beb\u79d2,\u54cd\u5e94\u5185\u5bb9:{}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), interval.toDurationMillis()});
            throw e;
        }
        endTime = new DateTime();
        interval = new Interval((ReadableInstant)startTime, (ReadableInstant)endTime);
        logger.info("\u65e5\u5fd7\u7edf\u4e00\u6253\u5370 ===== {}.{}() end =====,\u54cd\u5e94\u65f6\u95f4:{}\u6beb\u79d2,\u54cd\u5e94\u5185\u5bb9:{}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), interval.toDurationMillis(), this.argsToString(response)});
        return response;
    }

    private String argsToString(Object object) {
        try {
            return JSON.toJSONString((Object)object);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return String.valueOf(object);
        }
    }
}

