/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.log.converter;

import ch.qos.logback.classic.pattern.MessageConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SensitiveDataConverter
extends MessageConverter {
    private static Boolean converterCanRun = true;

    protected List<String> getSensitiveDataKeys() {
        return Lists.newArrayList();
    }

    public String convert(ILoggingEvent event) {
        String oriLogMsg = event.getFormattedMessage();
        if (converterCanRun.booleanValue()) {
            try {
                String processLogMsg = this.invokeMsg(oriLogMsg);
                return processLogMsg;
            }
            catch (Exception e) {
                System.out.println("\u8131\u654f\u5f02\u5e38,\u9ed8\u8ba4\u8fd4\u56de\u672a\u8131\u654f\u7684\u65e5\u5fd7\u4fe1\u606f\u3002\u5f02\u5e38\u539f\u56e0:" + e.getMessage());
                return oriLogMsg;
            }
        }
        return oriLogMsg;
    }

    public String invokeMsg(String oriMsg) {
        String tempMsg = oriMsg;
        List<String> sensitiveDataKeys = this.getSensitiveDataKeys();
        if (CollectionUtils.isNotEmpty(sensitiveDataKeys)) {
            for (String key : sensitiveDataKeys) {
                int index = -1;
                do {
                    if ((index = tempMsg.indexOf(key, index + 1)) == -1) continue;
                    int valueStart = this.getValueStartIndex(tempMsg, index + key.length());
                    int valueEnd = this.getValuEndEIndex(tempMsg, valueStart);
                    String subStr = tempMsg.substring(valueStart, valueEnd);
                    subStr = SensitiveDataConverter.desensitizeString(subStr);
                    tempMsg = tempMsg.substring(0, valueStart) + subStr + tempMsg.substring(valueEnd);
                } while (index != -1);
            }
        }
        return tempMsg;
    }

    private int getValueStartIndex(String msg, int valueStart) {
        while (valueStart < msg.length()) {
            char ch = msg.charAt(valueStart);
            if (ch == ':' || ch == '=') {
                if ((ch = msg.charAt(++valueStart)) != '\"') break;
                ++valueStart;
                break;
            }
            ++valueStart;
        }
        return valueStart;
    }

    private int getValuEndEIndex(String msg, int valueEnd) {
        while (valueEnd != msg.length()) {
            char ch = msg.charAt(valueEnd);
            if (ch == '\"') {
                if (valueEnd + 1 == msg.length()) break;
                char nextCh = msg.charAt(valueEnd + 1);
                if (nextCh == ';' || nextCh == ',') {
                    char preCh;
                    while (valueEnd > 0 && (preCh = msg.charAt(valueEnd - 1)) == '\\') {
                        --valueEnd;
                    }
                    break;
                }
                ++valueEnd;
                continue;
            }
            if (ch == ';' || ch == ',' || ch == '}') break;
            ++valueEnd;
        }
        return valueEnd;
    }

    private static String desensitizeString(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        int leftLength = str.length() / 3;
        int desensitizeLength = (str.length() - leftLength) / 2;
        int rigthLength = str.length() - desensitizeLength - leftLength;
        return StringUtils.left((String)str, (int)leftLength).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)str, (int)rigthLength), (int)StringUtils.length((CharSequence)str), (String)"*"), (String)Strings.padStart((String)"", (int)leftLength, (char)'*')));
    }
}

