/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.log.aop;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.rest.RestResponse;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Deprecated
public abstract class AbstractRestLogAspect {
    private static Logger logger = LoggerFactory.getLogger(AbstractRestLogAspect.class);

    public abstract void restLogAop();

    @Around(value="restLogAop()")
    public Object aroundRestApi(ProceedingJoinPoint point) throws Throwable {
        return this.log(point);
    }

    private Object log(ProceedingJoinPoint point) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Map<String, Object> paras = this.getArgsMap(methodSignature.getParameterNames(), point.getArgs());
        logger.info("\u65e5\u5fd7\u7edf\u4e00\u6253\u5370 ===== {}.{}() start =====,\u53c2\u6570:{}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), this.argsToString(paras)});
        LocalDateTime startTime = LocalDateTime.now();
        Object response = null;
        try {
            response = point.proceed();
        }
        catch (UndeclaredThrowableException e) {
            logger.error("\u672a\u77e5\u7684\u5f02\u5e38", (Throwable)e);
            response = e.getCause() instanceof InvocationTargetException ? new RestResponse(RestResponse.SUCCEED.getResultCode(), ((InvocationTargetException)e.getCause()).getTargetException().getMessage().replaceAll("Exception.*?]", ""), null) : new RestResponse(RestResponse.SUCCEED.getResultCode(), e.getCause().getMessage().replaceAll("Exception.*?]", ""), null);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            if (e instanceof RuntimeException) {
                response = !StringUtils.isEmpty((Object)e.getMessage()) && e.getMessage().contains("TimeOutException") ? new RestResponse(RestResponse.SUCCEED.getResultCode(), "\u8bf7\u6c42\u8d85\u65f6", null) : new RestResponse(RestResponse.SUCCEED.getResultCode(), e.getMessage().replaceAll("Exception.*?]", ""), null);
            }
            response = new RestResponse(RestResponse.SUCCEED.getResultCode(), "\u7cfb\u7edf\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01", null);
        }
        if (AbstractRestLogAspect.isTestFlow()) {
            try {
                ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                if (attributes != null) {
                    HttpServletResponse servletResponse = attributes.getResponse();
                    RestResponse restResponse = (RestResponse)response;
                    if (restResponse != null && !RestResponse.SUCCEED.getResultCode().equals(restResponse.getResultCode())) {
                        servletResponse.setStatus(500);
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u538b\u6d4b\u6d41\u91cf\u4fee\u6539httpresponse\u72b6\u6001\u7801\u5f02\u5e38", (Throwable)e);
            }
        }
        Duration interval = Duration.between(startTime, LocalDateTime.now());
        logger.info("\u65e5\u5fd7\u7edf\u4e00\u6253\u5370 ===== {}.{}() end =====,\u54cd\u5e94\u65f6\u95f4:{}\u6beb\u79d2,\u54cd\u5e94\u5185\u5bb9:{}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), interval.toMillis(), this.argsToString(response)});
        return response;
    }

    private static boolean isTestFlow() {
        return false;
    }

    private String argsToString(Object object) {
        try {
            return JSON.toJSONString((Object)object);
        }
        catch (Exception exception) {
            return String.valueOf(object);
        }
    }

    private Map<String, Object> getArgsMap(String[] paramsNames, Object[] objects) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (int i = 0; i < paramsNames.length; ++i) {
            if (objects[i] instanceof HttpServletResponse) continue;
            if (objects[i] instanceof HttpServletRequest) {
                resultMap.put(paramsNames[i], objects[i].toString());
                continue;
            }
            resultMap.put(paramsNames[i], objects[i]);
        }
        return resultMap;
    }
}

