/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.log.aop;

import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.log.LogUtil;
import com.dtyunxi.huieryun.log.operatelog.OperatorLogger;
import com.dtyunxi.huieryun.log.operatelog.annotation.EnableOperateLog;
import com.dtyunxi.huieryun.log.operatelog.dto.LogDto;
import com.dtyunxi.huieryun.log.operatelog.dto.OperateLogDto;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Order(value=8)
public class OperateLogAspect {
    private static Logger logger = LoggerFactory.getLogger(OperateLogAspect.class);
    private static final DateTimeFormatter DF_DATE_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    @Pointcut(value="@annotation(com.dtyunxi.huieryun.log.operatelog.annotation.EnableOperateLog)")
    private void annotationAop() {
    }

    @Around(value="annotationAop()")
    public Object controllerAround(ProceedingJoinPoint point) throws Throwable {
        try {
            String className = point.getTarget().getClass().getName();
            Class<?> clazz = Class.forName(className);
            Signature signature = point.getSignature();
            MethodSignature methodSignature = (MethodSignature)signature;
            Method targetMethod = methodSignature.getMethod();
            Method realMethod = point.getTarget().getClass().getDeclaredMethod(signature.getName(), targetMethod.getParameterTypes());
            OperateLogDto logDto = new OperateLogDto();
            this.doMakeLogDto(className, clazz, realMethod, methodSignature, point, logDto);
            LogDto vo = new LogDto(logDto);
            String json = JSONArray.toJSONString((Object)vo);
            OperatorLogger.log(json);
        }
        catch (Exception e) {
            logger.error("\u65e5\u5fd7\u62e6\u622a\u7ec4\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        return point.proceed();
    }

    private void doMakeLogDto(String classType, Class<?> clazz, Method realMethod, MethodSignature methodSignature, ProceedingJoinPoint point, OperateLogDto logDto) {
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes sra = (ServletRequestAttributes)ra;
        HttpServletRequest request = sra.getRequest();
        String operateModel = "";
        String operateContent = "";
        if (realMethod.isAnnotationPresent(EnableOperateLog.class)) {
            EnableOperateLog aop = realMethod.getAnnotation(EnableOperateLog.class);
            operateModel = aop.operateModel();
            operateContent = aop.operateContent();
        }
        Map<String, Object> paras = this.getArgsMap(methodSignature.getParameterNames(), point.getArgs());
        logDto.setOperateModel(operateModel);
        logDto.setOperateContent(operateContent);
        logDto.setOperatorId(ServiceContext.getContext().getRequestUserId());
        logDto.setUrl(request.getRequestURI());
        logDto.setOperator(ServiceContext.getContext().getRequestUserCode());
        logDto.setCreatePerson(ServiceContext.getContext().getRequestUserCode());
        logDto.setOperateParameter(JSONArray.toJSONString(paras));
        if (request != null) {
            logDto.setIpAddress(LogUtil.getRemoteIp(request));
        }
        String nowTime = DF_DATE_TIME.format(LocalDateTime.now());
        logDto.setId(System.currentTimeMillis());
        logDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        logDto.setOperateTime(nowTime);
        logDto.setCreateTime(nowTime);
        logDto.setUpdateTime(nowTime);
        logDto.setCreatePerson(ServiceContext.getContext().getRequestUserCode());
        logDto.setUpdatePerson(ServiceContext.getContext().getRequestUserCode());
        logDto.setDr(0);
    }

    private Map<String, Object> getArgsMap(String[] paramsNames, Object[] objects) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (int i = 0; i < paramsNames.length; ++i) {
            resultMap.put(paramsNames[i], objects[i]);
        }
        return resultMap;
    }
}

