/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.opensearch.provider.es6;

import com.dtyunxi.huieryun.opensearch.api.AbstractIndicesAdminService;
import com.dtyunxi.huieryun.opensearch.provider.es6.RestSearchClientUtils;
import com.dtyunxi.huieryun.opensearch.vo.OpenSearchVo;
import com.dtyunxi.util.JacksonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestIndicesAdminService
extends AbstractIndicesAdminService {
    private static final Logger logger = LoggerFactory.getLogger(RestIndicesAdminService.class);
    private RestHighLevelClient client = null;
    private IndicesClient indicesClient = null;

    public void init(OpenSearchVo openSearchVo) {
        this.openSearchVo = openSearchVo;
        this.client = RestSearchClientUtils.createClient(openSearchVo);
        this.indicesClient = this.client.indices();
    }

    public boolean createIndex(String indexName) {
        try {
            return this.indicesClient.create(new CreateIndexRequest(indexName), RequestOptions.DEFAULT).isAcknowledged();
        }
        catch (IOException e) {
            throw new RuntimeException("createIndex", e);
        }
    }

    public boolean createIndex(String indexName, Map<String, Object> settings) {
        try {
            return this.indicesClient.create(new CreateIndexRequest(indexName).settings(settings), RequestOptions.DEFAULT).isAcknowledged();
        }
        catch (IOException e) {
            throw new RuntimeException("createIndex", e);
        }
    }

    public boolean updateIndexSetting(String indexName, Map<String, Object> settings) {
        UpdateSettingsRequest request = new UpdateSettingsRequest(new String[]{indexName}).settings(settings);
        try {
            return this.indicesClient.putSettings(request, RequestOptions.DEFAULT).isAcknowledged();
        }
        catch (IOException e) {
            throw new RuntimeException("createIndex", e);
        }
    }

    public boolean existsIndex(String ... indexName) {
        try {
            return this.indicesClient.exists(new GetIndexRequest(indexName), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException("existsIndex", e);
        }
    }

    public boolean deleteIndex(String ... indexName) {
        try {
            return this.indicesClient.delete(new DeleteIndexRequest(indexName), RequestOptions.DEFAULT).isAcknowledged();
        }
        catch (IOException e) {
            throw new RuntimeException("deleteIndex", e);
        }
    }

    public String refreshAllIndices() {
        RefreshResponse response;
        try {
            response = this.indicesClient.refresh(new RefreshRequest(new String[0]), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException("refreshAllIndices", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(response.toString());
        }
        return response.toString();
    }

    public String refreshIndex(String ... indexName) {
        try {
            RefreshResponse response = this.indicesClient.refresh(new RefreshRequest(indexName), RequestOptions.DEFAULT);
            return response.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("refreshIndex", e);
        }
    }

    public boolean putMapping(String indexName, String tableName, String mappingSource) {
        try {
            return this.indicesClient.putMapping(new PutMappingRequest(new String[]{indexName}).source(mappingSource, XContentType.JSON), RequestOptions.DEFAULT).isAcknowledged();
        }
        catch (IOException e) {
            throw new RuntimeException("putMapping", e);
        }
    }

    public String getMapping(String indexName, String tableName) {
        Map mappings;
        try {
            mappings = this.indicesClient.getMapping(new GetMappingsRequest().indices(new String[]{indexName}), RequestOptions.DEFAULT).mappings();
        }
        catch (IOException e) {
            throw new RuntimeException("getMapping", e);
        }
        try {
            Map mapping;
            try {
                mapping = ((MappingMetaData)mappings.get(indexName)).getSourceAsMap();
            }
            catch (Exception e) {
                logger.error("Get Mapping Failure:", (Throwable)e);
                throw new RuntimeException(e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("contains key:" + mapping.containsKey("properties"));
            }
            return JacksonUtil.toJson(mapping.get("properties"));
        }
        catch (RuntimeException e) {
            logger.error("Get Mapping Failure:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean addIndexAliases(String aliases, String indexName) {
        try {
            AcknowledgedResponse response = this.indicesClient.updateAliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().index(indexName).aliases(new String[]{aliases})), RequestOptions.DEFAULT);
            if (logger.isDebugEnabled()) {
                logger.debug(response.toString());
            }
            return response.isAcknowledged();
        }
        catch (IOException e) {
            logger.error("Add aliases failure:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String[] getIndexNames(String aliases) {
        try {
            return this.indicesClient.get(new GetIndexRequest(new String[]{aliases}), RequestOptions.DEFAULT).getIndices();
        }
        catch (IOException e) {
            throw new RuntimeException("getIndexNames", e);
        }
    }

    public Map<String, Long> getIndexDocCounts(String ... aliases) {
        Map aliasesMap;
        try {
            aliasesMap = this.client.indices().getAlias(new GetAliasesRequest(aliases), RequestOptions.DEFAULT).getAliases();
        }
        catch (IOException e2) {
            throw new RuntimeException("getIndexDocCounts", e2);
        }
        return aliasesMap.keySet().stream().collect(Collectors.toMap(e -> e, this::getIndexDocCount));
    }

    public long getIndexDocCount(String indexName) {
        try {
            return this.client.count(new CountRequest(new String[]{indexName}), RequestOptions.DEFAULT).getCount();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getIndexIds(String indexName, int page, int pageSize) {
        SearchHits hits;
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).fetchSource("_id", null).from((page > 0 ? page - 1 : 0) * pageSize).size(pageSize);
        SearchRequest request = new SearchRequest().indices(new String[]{indexName}).source(sourceBuilder);
        try {
            hits = this.client.search(request, RequestOptions.DEFAULT).getHits();
        }
        catch (IOException e) {
            throw new RuntimeException("getIndexIds", e);
        }
        if (hits.totalHits == 0L) {
            return null;
        }
        SearchHit[] searchHits = hits.getHits();
        ArrayList<String> list = new ArrayList<String>(searchHits.length);
        for (SearchHit searchHit : searchHits) {
            list.add(searchHit.getId());
        }
        return list;
    }

    public boolean updateAliasesIndexRef(String aliases, String oldIndexName, String newIndexName) {
        IndicesAliasesRequest request = new IndicesAliasesRequest();
        request.addAliasAction(IndicesAliasesRequest.AliasActions.add().index(newIndexName).aliases(new String[]{aliases}));
        request.addAliasAction(IndicesAliasesRequest.AliasActions.remove().alias(aliases).index(oldIndexName));
        try {
            return this.indicesClient.updateAliases(request, RequestOptions.DEFAULT).isAcknowledged();
        }
        catch (IOException e) {
            logger.error("Update aliases failure:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected RestHighLevelClient getClient() {
        return this.client;
    }

    protected IndicesClient getIndicesClient() {
        return this.indicesClient;
    }

    public void closeSearchClient() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException("closeSearchClient", e);
        }
    }
}

