/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.starter.localcache;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.localcache.api.ILocalCacheService;
import com.dtyunxi.huieryun.localcache.api.LocalCacheFactory;
import com.dtyunxi.huieryun.localcache.vo.LocalCacheRegistryVo;
import com.dtyunxi.huieryun.starter.localcache.CacheEvent;
import com.dtyunxi.huieryun.starter.localcache.CacheMessage;
import com.dtyunxi.huieryun.starter.localcache.LocalCacheContext;
import com.dtyunxi.huieryun.starter.localcache.LocalCacheManager;
import com.dtyunxi.huieryun.starter.localcache.LocalCacheRegistryProperties;
import com.dtyunxi.util.FastJsonUtil;
import com.dtyunxi.util.JacksonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.NullValue;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.lang.Nullable;

public class LocalCache
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(LocalCache.class);
    private final LocalCacheRegistryProperties properties;
    private final boolean allowNullValues;
    private final ILocalCacheService localCacheService;
    private final ICacheService cacheService;
    private final String name;
    protected String group;

    public LocalCache(String name, LocalCacheRegistryProperties properties, ICacheService cacheService) {
        this.allowNullValues = properties.isAllowNullValues();
        this.name = name;
        this.localCacheService = properties.getLocalCache() != null ? LocalCacheFactory.createCache(null, (LocalCacheRegistryVo)properties.getLocalCache()) : null;
        this.properties = properties;
        this.cacheService = cacheService;
    }

    protected Object getActualBizKey(Object key) {
        return key;
    }

    @Nullable
    protected <T> Object lookup(Object key, @Nullable Type type) {
        Object clazz = type;
        if (clazz == null) {
            clazz = LocalCacheContext.getContext().getReturnType();
            if (log.isInfoEnabled()) {
                log.info("after get returnType form serviceContext,cacheName={},cacheKey={},returnType={}", new Object[]{this.name, key, clazz});
            }
            if (clazz == null) {
                clazz = Object.class;
            }
        }
        if (log.isInfoEnabled()) {
            log.info("lookup cache value,cacheName={},cacheKey={},returnType={}", new Object[]{this.name, key, clazz});
        }
        Object value = null;
        if (this.localCacheService != null) {
            String localKey = String.valueOf(key);
            value = this.group != null ? this.localCacheService.getCache(this.group, localKey, clazz.getClass()) : this.localCacheService.getCache(localKey, clazz.getClass());
        }
        if (value != null) {
            return value;
        }
        if (this.properties.isRemoteCache() && this.cacheService != null) {
            String remoteKey = this.combineKey(key);
            value = this.group != null ? this.cacheService.getCache(this.group, remoteKey, new GenericTypeReference((Type)clazz)) : this.cacheService.getCache(remoteKey, new GenericTypeReference((Type)clazz));
            if (value != null && this.localCacheService != null) {
                String localKey = String.valueOf(key);
                if (this.group != null) {
                    this.localCacheService.setCache(this.group, localKey, value);
                } else {
                    this.localCacheService.setCache(localKey, value);
                }
            }
        }
        return value;
    }

    public String getName() {
        return this.name;
    }

    public Object getNativeCache() {
        return this;
    }

    @Nullable
    public Cache.ValueWrapper get(Object key) {
        if (log.isDebugEnabled()) {
            log.debug("get,cacheName={},cacheKey={}", (Object)this.name, key);
        }
        key = this.getActualBizKey(key);
        Object value = this.lookup(key, null);
        return this.toValueWrapper(value);
    }

    @Nullable
    public <T> T get(Object key, @Nullable Class<T> type) {
        Object value;
        if (log.isDebugEnabled()) {
            log.debug("get,cacheName={},cacheKey={},type={}", new Object[]{this.name, key, type});
        }
        if ((value = this.fromStoreValue(this.lookup(key = this.getActualBizKey(key), type))) != null && type != null && !type.isInstance(value)) {
            throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
        }
        return (T)value;
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        Object value;
        if (log.isDebugEnabled()) {
            log.debug("get,cacheName={},cacheKey={},valueLoader.type={}", new Object[]{this.name, key, valueLoader.getClass().getGenericSuperclass()});
        }
        if ((value = this.lookup(key = this.getActualBizKey(key), null)) != null) {
            return (T)value;
        }
        try {
            value = valueLoader.call();
            Object storeValue = this.toStoreValue(value);
            this.put(key, storeValue);
            return (T)value;
        }
        catch (Exception e) {
            throw new Cache.ValueRetrievalException(key, valueLoader, e.getCause());
        }
    }

    public void put(Object key, Object value) {
        if (log.isDebugEnabled()) {
            log.debug("put,cacheName={},cacheKey={},value={}", new Object[]{this.name, key, value});
        }
        key = this.getActualBizKey(key);
        if (this.properties.isRemoteCache()) {
            String remoteKey = this.combineKey(key);
            if (this.group != null) {
                this.cacheService.setCache(this.group, remoteKey, value);
            } else {
                this.cacheService.setCache(remoteKey, value);
            }
        }
        if (this.localCacheService != null) {
            String localKey = String.valueOf(key);
            if (this.group != null) {
                this.localCacheService.setCache(this.group, localKey, value);
            } else {
                this.localCacheService.setCache(localKey, value);
            }
            if (this.cacheService != null) {
                this.distributeEvent(CacheEvent.PUT, localKey, value);
            }
        }
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Object oldValue;
        if (log.isDebugEnabled()) {
            log.debug("putIfAbsent,cacheName={},cacheKey={},value={}", new Object[]{this.name, key, value});
        }
        if (null == (oldValue = this.lookup(key = this.getActualBizKey(key), value.getClass()))) {
            this.put(key, value);
        }
        return this.toValueWrapper(oldValue);
    }

    public void evict(Object key) {
        if (log.isDebugEnabled()) {
            log.debug("evict,cacheName={},cacheKey={}", (Object)this.name, key);
        }
        key = this.getActualBizKey(key);
        if (this.properties.isRemoteCache()) {
            String remoteKey = this.combineKey(key);
            if (this.group != null) {
                this.cacheService.delCache(this.group, remoteKey);
            } else {
                this.cacheService.delCache(remoteKey);
            }
        }
        if (this.localCacheService != null) {
            String localKey = String.valueOf(key);
            if (this.group != null) {
                this.localCacheService.delCache(this.group, localKey);
            } else {
                this.localCacheService.delCache(localKey);
            }
            if (this.cacheService != null) {
                this.distributeEvent(CacheEvent.EVICT, localKey, null);
            }
        }
    }

    public void clear() {
        if (log.isDebugEnabled()) {
            log.debug("clear");
        }
        if (this.properties.isRemoteCache()) {
            if (this.group != null) {
                this.cacheService.delCacheByPattern(this.group, this.combineKey("*"));
            } else {
                this.cacheService.delCacheByPattern(this.combineKey("*"));
            }
        }
        if (this.localCacheService != null) {
            this.localCacheService.deleteAllCacheValues();
            this.distributeEvent(CacheEvent.CLEAR, null, null);
        }
    }

    private void distributeEvent(CacheEvent event, String key, Object value) {
        CacheMessage message = new CacheMessage(LocalCacheManager.COMMON_SRC, event, this.name);
        message.setKey(key);
        message.setValue(FastJsonUtil.toJSONString((Object)value));
        message.setGroup(this.group);
        message.setParameterTypes(value == null ? null : value.getClass().getName());
        if (this.group != null) {
            this.cacheService.publish(this.group, this.properties.getCacheSyncTopic(), JacksonUtil.toJson((Object)message));
        } else {
            this.cacheService.publish(this.properties.getCacheSyncTopic(), JacksonUtil.toJson((Object)message));
        }
    }

    @Nullable
    protected Object fromStoreValue(@Nullable Object storeValue) {
        if (this.allowNullValues && storeValue == NullValue.INSTANCE) {
            return null;
        }
        return storeValue;
    }

    protected Object toStoreValue(@Nullable Object userValue) {
        if (userValue == null) {
            if (this.allowNullValues) {
                return NullValue.INSTANCE;
            }
            throw new IllegalArgumentException("Cache '" + this.getName() + "' is configured to not allow null values but null was provided");
        }
        return userValue;
    }

    @Nullable
    protected Cache.ValueWrapper toValueWrapper(@Nullable Object storeValue) {
        return storeValue != null ? new SimpleValueWrapper(this.fromStoreValue(storeValue)) : null;
    }

    private String combineKey(Object key) {
        return this.name + ":" + key;
    }

    public ILocalCacheService getLocalCacheService() {
        return this.localCacheService;
    }

    public ICacheService getCacheService() {
        return this.cacheService;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    private static class GenericTypeReference<T>
    extends TypeReference<T> {
        protected final Type _type;

        public GenericTypeReference(Type clazz) {
            this._type = clazz;
        }

        public Type getType() {
            return this._type;
        }
    }
}

