/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.starter.localcache;

import cn.hutool.core.util.RandomUtil;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCacheContext {
    private static final Logger log = LoggerFactory.getLogger(LocalCacheContext.class);
    public static final String METHOD_RETURN_TYPE = "localcache.method.returnType";
    private static final ThreadLocal<LocalCacheContext> LOCAL = ThreadLocal.withInitial(() -> new LocalCacheContext());
    private final Long contextId = RandomUtil.randomLong((long)Long.MAX_VALUE);
    private final Map<String, Object> mapValue = new ConcurrentHashMap<String, Object>();

    public static LocalCacheContext getContext() {
        return LOCAL.get();
    }

    public void set(String key, Object value) {
        if (value == null) {
            this.mapValue.remove(key);
        } else {
            this.mapValue.put(key, value);
        }
    }

    public void remove(String key) {
        this.mapValue.remove(key);
    }

    public Object get(String key) {
        return this.mapValue.get(key);
    }

    public Type getReturnType() {
        if (log.isInfoEnabled()) {
            log.info("getReturnType, contextId={}", (Object)this.contextId);
        }
        return (Type)this.mapValue.get(METHOD_RETURN_TYPE);
    }

    public void setReturnType(Type returnType) {
        if (log.isInfoEnabled()) {
            log.info("setReturnType, contextId={}, returnType={}", (Object)this.contextId, (Object)returnType);
        }
        this.mapValue.put(METHOD_RETURN_TYPE, returnType);
    }

    public void removeReturnType() {
        log.info("removeReturnType, contextId={}", (Object)this.contextId);
        this.mapValue.remove(METHOD_RETURN_TYPE);
    }
}

