/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.maven.plugins;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.huieryun.maven.plugins.CubeAbstractMojo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

@Mojo(name="chart-replace", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class ChartReplaceMojo
extends CubeAbstractMojo {
    @Parameter(defaultValue="${project}")
    public MavenProject project;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd-HHmmss");

    @Override
    protected void executeInner() throws IOException {
        try {
            this.replaceChart();
        }
        catch (Exception e) {
            this.getLog().warn((Throwable)e);
        }
    }

    private void replaceChart() throws IOException {
        String chartsDir = "";
        MavenProject parent = this.project.getParent();
        chartsDir = parent != null && this.project.getName().contains(parent.getArtifactId()) ? parent.getBasedir().getAbsolutePath() + File.separator + "charts" + File.separator + parent.getName() : this.getBasedir().getAbsolutePath() + File.separator + "charts" + File.separator + this.project.getName();
        File charDirFolder = new File(chartsDir);
        if (charDirFolder.exists() && charDirFolder.isDirectory()) {
            String[] targetFiles;
            String mavenVersion = this.project.getVersion();
            String chartVersion = this.dateFormat.format(new Date()).replaceAll("\\.0", "\\.") + "-" + mavenVersion;
            for (String targetFile : targetFiles = new String[]{"Chart.yaml", "yxinstall" + File.separator + "install.yaml"}) {
                targetFile = chartsDir + File.separator + targetFile;
                File file = new File(targetFile);
                if (!file.exists()) {
                    this.getLog().info((CharSequence)("\u8df3\u8fc7\u4e0d\u5b58\u5728\u7684\u6587\u4ef6\uff1a" + targetFile));
                    continue;
                }
                Yaml yaml = new Yaml();
                FileInputStream in = new FileInputStream(file);
                Map installYamlMap = (Map)yaml.load((InputStream)in);
                for (String key : installYamlMap.keySet()) {
                    if (!key.toLowerCase().contains("version") || installYamlMap.get(key) == null) continue;
                    String v = installYamlMap.get(key).toString().replaceAll("null", "").replaceAll("=", "");
                    if (v.contains("{{chartVersion}}")) {
                        installYamlMap.put(key, chartVersion);
                    }
                    if (!v.contains("{{appVersion}}")) continue;
                    installYamlMap.put(key, mavenVersion);
                }
                if (targetFile.endsWith("Chart.yaml")) {
                    installYamlMap.put("version", chartVersion);
                    installYamlMap.put("appVersion", mavenVersion);
                }
                if (targetFile.endsWith("install.yaml")) {
                    installYamlMap.put("version", mavenVersion);
                    List dependencies = this.project.getDependencies();
                    if (dependencies != null && dependencies.size() > 0) {
                        JSONArray bundles;
                        HashMap<String, String> bundleDependencyMap = new HashMap<String, String>();
                        Object o = installYamlMap.get("bundles");
                        if (o != null && (bundles = (JSONArray)JSONObject.toJSON(installYamlMap.get("bundles"))) != null) {
                            bundles.forEach(jsonObject -> {
                                JSONObject j = (JSONObject)jsonObject;
                                bundleDependencyMap.put(j.get((Object)"name").toString(), j.get((Object)"version").toString());
                            });
                        }
                        bundles = dependencies.iterator();
                        while (bundles.hasNext()) {
                            Dependency dependency = (Dependency)bundles.next();
                            String artifactId = dependency.getArtifactId();
                            if (!artifactId.startsWith("bundle") || !artifactId.endsWith("service")) continue;
                            String artifactIdWithoutPrefix = this.cutSuffix(dependency.getArtifactId());
                            if (parent != null && artifactIdWithoutPrefix.equals(parent.getArtifactId())) continue;
                            String bundleName = dependency.getGroupId() + "_" + artifactIdWithoutPrefix;
                            bundleName = bundleName.replace("_bundle-", "_");
                            bundleDependencyMap.put(bundleName, dependency.getVersion());
                        }
                        if (bundleDependencyMap.size() > 0) {
                            bundles = new JSONArray();
                            for (String bundleName : bundleDependencyMap.keySet()) {
                                JSONObject jsonObject2 = new JSONObject();
                                jsonObject2.put("name", (Object)bundleName);
                                jsonObject2.put("version", bundleDependencyMap.get(bundleName));
                                bundles.add((Object)jsonObject2);
                            }
                            installYamlMap.put("bundles", bundles);
                        }
                    }
                }
                DumperOptions dumperOptions = new DumperOptions();
                dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
                Yaml wyaml = new Yaml(dumperOptions);
                String s = wyaml.dump((Object)installYamlMap);
                s = s.replace("null", "");
                BufferedWriter out = new BufferedWriter(new FileWriter(targetFile));
                out.write(s);
                out.close();
            }
        } else {
            this.getLog().info((CharSequence)("\u6ca1\u6709charts\u76ee\u5f55" + chartsDir + "\uff0c\u5ffd\u7565"));
        }
    }

    private String cutSuffix(String artifactId) {
        if (artifactId.endsWith("biz")) {
            artifactId = artifactId.substring(0, artifactId.length() - "biz".length());
        } else if (artifactId.endsWith("service")) {
            artifactId = artifactId.substring(0, artifactId.length() - "service".length());
        } else if (artifactId.endsWith("conf")) {
            artifactId = artifactId.substring(0, artifactId.length() - "conf".length());
        } else if (artifactId.endsWith("dao")) {
            artifactId = artifactId.substring(0, artifactId.length() - "dao".length());
        } else if (artifactId.endsWith("stdeo")) {
            artifactId = artifactId.substring(0, artifactId.length() - "stdeo".length());
        } else if (artifactId.endsWith("eo")) {
            artifactId = artifactId.substring(0, artifactId.length() - "eo".length());
        }
        return artifactId;
    }

    private void replaceFile(File file, String appVersion, String chartVersion) throws IOException {
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        BufferedReader bufIn = new BufferedReader(isr);
        String content = "";
        String line = null;
        while ((line = bufIn.readLine()) != null) {
            line = line.replaceAll("\\{\\{chartVersion\\}\\}", chartVersion);
            line = line.replaceAll("\\{\\{appVersion\\}\\}", appVersion);
            content = content + line + "\n";
        }
        bufIn.close();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        osw.write(content);
        osw.flush();
        osw.close();
    }
}

