/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.alarm.client.config;

import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.alarm.api.IAlarmRuleExecutor;
import com.dtyunxi.yundt.cube.alarm.api.IAlarmRuleManager;
import com.dtyunxi.yundt.cube.alarm.api.IMonitorDataFetcher;
import com.dtyunxi.yundt.cube.alarm.api.impl.DefaultAlarmRuleManager;
import com.dtyunxi.yundt.cube.alarm.client.AlarmClient;
import com.dtyunxi.yundt.cube.alarm.client.config.AlarmClientProperties;
import com.dtyunxi.yundt.cube.alarm.client.config.SchedulerConfig;
import com.dtyunxi.yundt.cube.alarm.client.job.AlarmJob;
import com.dtyunxi.yundt.cube.alarm.client.sender.AlarmSender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@Configurable
@EnableConfigurationProperties(value={AlarmClientProperties.class})
@Import(value={SchedulerConfig.class})
public class AlarmClientAutoConfiguration {
    @Autowired
    private AlarmClientProperties alarmClientProperties;

    @Bean(value={"alarmJob"})
    public AlarmJob alarmJob(AlarmClient alarmClient) {
        return new AlarmJob(alarmClient);
    }

    @Bean
    public IAlarmRuleManager alarmRuleManager(ICacheService cacheService) {
        DefaultAlarmRuleManager alarmRuleManager = new DefaultAlarmRuleManager(cacheService);
        return alarmRuleManager;
    }

    @Bean
    public AlarmClient alarmClient(AlarmSender alarmSender, IAlarmRuleManager alarmRuleManager, IMonitorDataFetcher monitorDataFetcher, IAlarmRuleExecutor alarmRuleExecutor) {
        AlarmClient client = new AlarmClient(this.alarmClientProperties.getApplicationName(), alarmRuleManager, alarmSender, monitorDataFetcher, alarmRuleExecutor);
        return client;
    }

    @Bean
    public AlarmSender alarmSender(ICommonsMqService commonsMqService) {
        AlarmSender sender = new AlarmSender(commonsMqService, this.alarmClientProperties.getMqTopic());
        return sender;
    }
}

