/*
 * *
 *  * @(#)StringToDateConverter.java 2.0.0 1/17/19 5:42 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.center.converter;

import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.StringUtils;

import java.util.Date;

/**
 * @author luo.lei
 * @since 2.0.0
 */
public class StringToDateConverter implements Converter<String,Date> {

    public static final DateTimeFormatter SHORT_PATTERN = DateTimeFormat.forPattern("yyyy-MM-dd");

    public static final DateTimeFormatter PATTERN =DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");

    @Override
    public Date convert(String source) {
        if (StringUtils.isEmpty(source)) {
            return null;
        }

        try {
            return LocalDateTime.parse(source,PATTERN ).toDate();
        } catch (Exception e) {
            // ignore
        }

        try {
            return LocalDateTime.parse(source, SHORT_PATTERN).toDate();
        } catch (Exception e) {
            // ignore
        }
        throw new IllegalArgumentException("Invalid date formatter '" + source + "' . support pattern [yyyy-MM-dd ,yyyy-MM-dd HH:mm:ss ]");
    }
}
