/**
 * @(#) Criteria.java 1.0 2018-12-19
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.condition;

import com.dtyunxi.eo.SqlFilter;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * 通用查询对象
 *
 * @author 刘备
 * @since 1.0.0
 */
public class Criteria {

    //租户Id
    private Long tenantId;

    //应用实例Id
    private Long instanceId;

    //查询条件
    private List<SqlFilter> filters = Lists.newArrayList();

    //需要返回的字段, 不指定则为*
    private List<String> fields;

    //关联查询, 需要返回的关联对象，如user的address、billInfo、personalInfo
    private List<String> reses = Lists.newArrayList();

    //升序字段,多个字段时逗号隔开
    private String orderBy;

    //降序字段,多个字段时逗号隔开
    private String orderByDesc;

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public List<SqlFilter> getFilters() {
        if (this.tenantId != null) {
            filters.add(SqlFilter.eq("tenantId", this.tenantId));
        }
        if (this.instanceId != null) {
            filters.add(SqlFilter.eq("instanceId", this.instanceId));
        }
        return filters;
    }

    public void setFilters(List<SqlFilter> filters) {
        this.filters = filters;
    }

    public List<String> getFields() {
        return fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public List<String> getReses() {
        return reses;
    }

    public void setReses(List<String> reses) {
        this.reses = reses;
    }

    public String getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }
}