package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.config;

import com.fasterxml.jackson.annotation.JsonFormat;
import feign.RequestTemplate;
import feign.codec.EncodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 重写的 SpringEncoder 配置：将 GET 请求中拥有的 requestBody 去掉，将其转换成 query 参数
 * @author : Y.H.Q
 */
@Configuration
public class MySpringEncoder extends SpringEncoder {

    private static Logger logger = LoggerFactory.getLogger(MySpringEncoder.class);

    public MySpringEncoder(ObjectFactory<HttpMessageConverters> messageConverters) {
        super(messageConverters);
    }

    /**
     * 获取类的全部属性，含父类属性
     * @author : 萧玄
     * @Date   : 14:42 2019/6/20
     * @param clz
     * @return : java.lang.reflect.Field[]
     */
    public static Field[] getAllFields(Class<?> clz){
        if(clz == null){
            return new Field[]{};
        }
        Field[] fields = clz.getDeclaredFields();
        Field[] parentFields = getAllFields(clz.getSuperclass());
        Field[] finalF = new Field[fields.length+parentFields.length];
        int i = 0;
        Map<String,Boolean> existMap = new HashMap<>();
        for(Field field:parentFields){
            existMap.put(field.getName(),true);
            finalF[i++] = field;
        }
        for(Field field:fields){
            if(!existMap.containsKey(field.getName())){
                finalF[i++] = field;
            }
        }
        return finalF;
    }

    @Override
    public void encode(Object requestBody, Type bodyType, RequestTemplate request) throws EncodeException {
        if (request.method().equals(HttpMethod.GET.name()) && requestBody!=null) {
            //GET请求方式去掉requestbody，并将requestBody参数转换成url参数
            Map<String, Collection<String>> queries = new HashMap<>();
            try {
                Field[] fields = getAllFields(Class.forName(bodyType.getTypeName()));
                for (int i=0; i<fields.length ; i++) {
                    Field field = fields[i];
                    if(null==field){
                        continue;
                    }
                    try {
                        field.setAccessible(true);
                        Object value = field.get(requestBody);
                        if(value == null){
                            continue;
                        }
                        getValueOfFiled("",queries,field, requestBody,value, field.getDeclaredAnnotations());
                    } catch (IllegalAccessException e) {
                        logger.warn("GET请求体参数转换异常：{}",e);
                    }
                }
            } catch (ClassNotFoundException e) {
                logger.warn("GET请求体参数转换异常2：{}",e);
            }
            request.queries(queries);
            super.encode(null, null, request);
        } else {
            super.encode(requestBody, bodyType, request);
        }
    }

    /**
     * 将原本要生成requestBody的参数转换成 queries,并进行参数编码
     * queries格式：
     * 参数名：参数值列表
     * {
     * 	"ageSex.simpleMap%5Bdiaonaxing%5D": ["%E5%86%85%E9%83%A8InnerDto%EF%BC%9A%E9%9B%95%E5%A8%9C%E6%98%9F"],
     * 	"ageSex.testListDtoList%5B0%5D.code": ["1"],
     * 	"testListDtos%5B0%5D.code": ["3"],
     * 	"ageSex.testListDtoList%5B1%5D.code": ["2"],
     * 	"testListDtoList%5B0%5D.address": ["%E5%A4%A9%E6%B2%B3"],
     * 	"ageSex.testListDtoList%5B0%5D.address": ["%E5%86%85%E9%83%A8InnerDto%EF%BC%9A%E5%A4%A9%E6%B2%B3"],
     * 	"simpleMap%5Bdiaonaxing%5D": ["%E9%9B%95%E5%A8%9C%E6%98%9F"],
     * 	"testListDtoList%5B1%5D.code": ["2"],
     * 	"testListDtos%5B1%5D.code": ["4"],
     * 	"ageSex.priceList": ["1", "2"],
     * 	"priceList": ["1", "2"],
     * 	"testListDtoList%5B1%5D.address": ["%E8%B6%8A%E7%A7%80"],
     * 	"ageSex.remarkList": ["%E5%86%85%E9%83%A8InnerDto%EF%BC%9A%E9%9B%95%E5%A8%9C%E6%98%9F", "%E5%86%85%E9%83%A8InnerDto%EF%BC%9A%E7%8E%A9%E8%BF%98%E6%98%AF%E8%AF%B4"],
     * 	"ageSex.dates": ["Thu+Apr+04+17%3A21%3A26+CST+2019", "Thu+Apr+04+17%3A21%3A26+CST+2019"],
     * 	"ageSex.prices": ["3", "4"],
     * 	"id": ["123"],
     * 	"ageSex.age": ["10", "10"],
     * 	"prices": ["3", "4"],
     * 	"ageSex.birthDay": ["2019-04-04+17%3A21%3A26.779"],
     * 	"testListDtoList%5B0%5D.code": ["1"],
     * 	"remarkList": ["%E9%9B%95%E5%A8%9C%E6%98%9F", "%E7%8E%A9%E8%BF%98%E6%98%AF%E8%AF%B4"],
     * 	"birthDay": ["2019-04-04+17%3A21%3A26.779"],
     * 	"ageSex.remarks": ["%E5%86%85%E9%83%A8InnerDto%EF%BC%9A%E5%BE%88%E5%A4%9A%E5%BE%88%E5%A4%9A", "%E5%86%85%E9%83%A8InnerDto%EF%BC%9A%E7%A5%9E%E7%BB%8F%E8%AE%A1%E7%AE%97%E6%9C%BA"],
     * 	"testListDtos%5B0%5D.address": ["%E9%BB%84%E5%9F%94"],
     * 	"ageSex.dateList": ["Thu+Apr+04+17%3A21%3A26+CST+2019", "Thu+Apr+04+17%3A21%3A26+CST+2019", "Wed+Oct+10+17%3A21%3A26+CST+2018"],
     * 	"ageSex.testListDtos%5B0%5D.address": ["%E5%86%85%E9%83%A8InnerDto%EF%BC%9A%E9%BB%84%E5%9F%94"],
     * 	"dates": ["Thu+Apr+04+17%3A21%3A26+CST+2019", "Thu+Apr+04+17%3A21%3A26+CST+2019"],
     * 	"ageSex.simpleMap%5Bcaonima%5D": ["%E5%86%85%E9%83%A8InnerDto%EF%BC%9A%E7%BE%8A%E9%A9%BC"],
     * 	"ageSex.testListDtoList%5B1%5D.address": ["%E5%86%85%E9%83%A8InnerDto%EF%BC%9A%E8%B6%8A%E7%A7%80"],
     * 	"simpleMap%5Bcaonima%5D": ["%E7%BE%8A%E9%A9%BC"],
     * 	"name": ["faker"],
     * 	"ageSex.testListDtos%5B0%5D.code": ["3"],
     * 	"dateList": ["Thu+Apr+04+17%3A21%3A26+CST+2019", "Thu+Apr+04+17%3A21%3A26+CST+2019", "Wed+Oct+10+17%3A21%3A26+CST+2018"],
     * 	"ageSex.sex": ["%E7%94%B7", "%E5%86%85%E9%83%A8InnerDto%EF%BC%9A%E7%94%B7"],
     * 	"ageSex.testListDtos%5B1%5D.code": ["4"],
     * 	"remarks": ["%E5%BE%88%E5%A4%9A%E5%BE%88%E5%A4%9A", "%E7%A5%9E%E7%BB%8F%E8%AE%A1%E7%AE%97%E6%9C%BA"]
     * }
     *
     *
     *
     * @param prefix 参数映射集入哈希槽的前缀
     * @param queries 参数映射集
     * @param field 属性对象
     * @param requestBody 请求体参数实例对象
     * @param annotations 属性注解数组
     * @author : Y.H.Q
     */
    private void getValueOfFiled(String prefix,Map<String, Collection<String>> queries,Field field, Object requestBody,Object value,Annotation[] annotations) throws IllegalAccessException {
        Class<?> clz = field.getType();
        if (Collection.class.isAssignableFrom(clz)) {
            //集合
            Collection collection = (Collection) value;
            int i = 0;
            for (Object o:collection) {
                dealWithElement(prefix,queries,field.getName(),o,i++,annotations);
            }
        } else if (Map.class.isAssignableFrom(clz)) {
            //Map
            try {
                buildMapProperty2Query(prefix, queries, (Map) field.get(requestBody), field.getName());
            } catch (IllegalAccessException e) {
                logger.warn("属性访问安全性异常：{}",e);
            }
        } else if (Date.class.isAssignableFrom(clz)) {
            //Date类型
            JsonFormat jsonFormat = field.getAnnotation(JsonFormat.class);
            if(jsonFormat != null){
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(jsonFormat.pattern());
                putQuery(queries,prefix+field.getName(),simpleDateFormat.format((Date)value));
            }else{
                putQuery(queries,prefix+field.getName(),value);
            }
        } else if (clz.isArray()) {
            //数组
            Object[] objects = (Object[])value;
            for(int i =0;i <objects.length;++i){
                dealWithElement(prefix,queries,field.getName(),objects[i],i,annotations);
            }
        } else if(Enum.class.isAssignableFrom(clz)){
            Enum e = (Enum)value;
            putQuery(queries,prefix+field.getName(),e.name());
        }else {
            //基础数据类型或者其封装类，以及String、StringBuild、StringBuffer
            if (canDirectlyTransefer(clz)) {
                putQuery(queries,prefix+field.getName(),field.get(requestBody));
            }else{
                //其他类型：自定义类或者其他类
                Field[] fields = value.getClass().getDeclaredFields();
                for(Field f:fields){
                    f.setAccessible(true);
                    Object v = f.get(value);
                    if(v == null){
                        continue;
                    }
                    getValueOfFiled(field.getName()+".",queries,f,value,v,annotations);
                }
            }
        }
    }

    /**
     * map属性转换成query参数
     * @author : Y.H.Q
     * @param prefix 参数映射集入哈希槽的前缀
     * @param queries 参数映射集
     * @param o2 映射集
     * @param name 属性名称
     * @return
     */
    private void buildMapProperty2Query(String prefix, Map<String, Collection<String>> queries, Map o2, String name) {
        Map<Object, Object> map = o2;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            StringBuilder key = new StringBuilder();
            StringBuilder value = new StringBuilder();
            value.append("[").append(entry.getKey()).append("]");
            key.append(name).append(encodeValue(value));
            putQuery(queries, prefix + key, entry.getValue());
        }
    }

    /**
     * 解析数组元素
     * @param prefix 参数映射集入哈希槽的前缀
     * @param queries 参数映射集
     * @param key 当前数组元素所属属性的属性名称
     * @param object 当前元素值
     * @param index 当前下标
     * @param annotations 属性注解数组
     *
     * @author : Y.H.Q
     */
    private void dealWithElement(String prefix,Map<String, Collection<String>> queries,String key,Object object,int index,Annotation[] annotations) throws IllegalAccessException {
        if (object == null){
            return;
        }
        Class<?> clz = object.getClass();
        if (Collection.class.isAssignableFrom(clz)) {
            //集合
            Collection collection = (Collection) object;
            int i = 0;
            for (Object o:collection) {
                dealWithElement(prefix,queries,key,o,i++,annotations);
            }
        } else if (Map.class.isAssignableFrom(clz)) {
            //Map映射集
            buildMapProperty2Query(prefix, queries, (Map) object, key);
        } else if (Date.class.isAssignableFrom(clz)) {
            //日期类型
            JsonFormat jsonFormat = null;
            for(Annotation annotation :annotations){
                if(annotation.getClass().isAssignableFrom(JsonFormat.class)){
                    jsonFormat = (JsonFormat) annotation;
                }
            }
            if(jsonFormat != null){
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(jsonFormat.pattern());
                putQuery(queries,prefix+key,simpleDateFormat.format((Date)object));
            }else{
                putQuery( queries,prefix+key,object);
            }
        } else if (clz.isArray()) {
            //数组
            Object[] objects = (Object[])object;
            for(int i =0;i <objects.length;++i){
               dealWithElement(prefix,queries,key,objects[i],i,annotations);
            }
        }else if(Enum.class.isAssignableFrom(clz)){
            Enum e = (Enum)object;
            putQuery(queries,prefix+key,e.name());
        }else {
            if (canDirectlyTransefer(clz)) {
                //基础数据类型及其封装类，以及String/StringBuilder/StringBuffer
                putQuery(queries,prefix+key,object);
            }else{
                //其他类型：自定义类或者其他类
                Field[] fields = object.getClass().getDeclaredFields();
                for(Field f:fields){
                    f.setAccessible(true);
                    Object v = f.get(object);
                    if(v == null){
                        continue;
                    }
                    getValueOfFiled(prefix+key+encodeValue("["+index+"]."),queries,f,object,v,annotations);
                }
            }
        }
    }

    /**
     * 能够直接转换的类型
     * @author : Y.H.Q
     * @param clz 元素或者属性的Class类型
     * @return
     */
    public static boolean canDirectlyTransefer(Class<?> clz) {
        return int.class.isAssignableFrom(clz) || short.class.isAssignableFrom(clz) || byte.class.isAssignableFrom(clz) || boolean.class.isAssignableFrom(clz)
                || long.class.isAssignableFrom(clz) || float.class.isAssignableFrom(clz) || double.class.isAssignableFrom(clz) || char.class.isAssignableFrom(clz)
                || Integer.class.isAssignableFrom(clz) || Short.class.isAssignableFrom(clz) || Byte.class.isAssignableFrom(clz) || Boolean.class.isAssignableFrom(clz)
                || Long.class.isAssignableFrom(clz) || Float.class.isAssignableFrom(clz) || Double.class.isAssignableFrom(clz) || Character.class.isAssignableFrom(clz)
                || String.class.isAssignableFrom(clz) || StringBuilder.class.isAssignableFrom(clz) || StringBuffer.class.isAssignableFrom(clz);
    }

    /**
     * 参数编码
     * @author : Y.H.Q
     * @Date: 16:57 2019/4/4
     * @param value 值
     * @return
     */
    private String encodeValue(Object value) {
        return String.valueOf(value);
//        try {
//            return URLEncoder.encode(value.toString(), "UTF-8");
//        } catch (UnsupportedEncodingException e) {
//            logger.warn("参数编码异常：{}",e);
//        }
//        return "";
    }

    /**
     * 将数据存入queries映射表
     * @author : Y.H.Q
     * @param queries 参数映射集
     * @param key 参数名称
     * @param value 参数值
     * @return
     */
    private void putQuery(Map<String, Collection<String>> queries,String key,Object value){
        Collection<String> values = null;
        if(queries.containsKey(key)){
            values = queries.get(key);
        }else {
            values = new ArrayList<>();
            queries.put(key,values);
        }
        values.add(encodeValue(value));
    }

}
