package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.config;

import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.form.spring.SpringFormEncoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.web.multipart.MultipartFile;

import java.lang.reflect.Type;

/**
 * feign的form表单编码器
 * @author : 萧玄
 * @Date: 11:22 2019/8/2
 */
@Configuration
@Primary
public class MySpringFormEncoder extends SpringFormEncoder {

    @Autowired
    private MySpringEncoder mySpringEncoder;

    /**
     * 重写encode方法：当非MultipartFile文件的时候使用自己的springEncoder编码器
     *
     * @author : YHQ
     */
    @Override
    public void encode(Object object, Type bodyType, RequestTemplate template) throws EncodeException {
        if (!bodyType.equals(MultipartFile.class)) {
            mySpringEncoder.encode(object, bodyType, template);
        } else {
            super.encode(object, bodyType, template);
        }
    }
}
