package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.constants.enums;

/**
 * 会员中心模块类型
 */
public enum ModuleType {

    /**
     * 优惠活动模块
     */
    ACTIVITY(1, "activityAutoConfig","优惠活动模块"),

    /**
     * 生命周期引擎模块
     */
    EVENT_ENGINE(2, "eventEngineAutoConfig","生命周期引擎模块"),

    /**
     * 主动营销模块
     */
    MARKETING_ENGINE(3, "marketingEngineAutoConfig","主动营销模块"),

    /**
     * 主动营销模块
     */
    TAG(4, "tagAutoConfig","智能圈人");

    private int code;

    private String tagClass;

    private String desc;

    ModuleType(int code, String tagClass, String desc) {
        this.code = code;
        this.tagClass = tagClass;
        this.desc = desc;
    }

    public static ModuleType valueOf(int code){
        ModuleType[] statusArray = ModuleType.values();
        for (ModuleType status :statusArray) {
            if(status.getCode()==code){
                return status;
            }
        }
        return null;
    }

    public String getTagClass() {
        return tagClass;
    }

    public void setTagClass(String tagClass) {
        this.tagClass = tagClass;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
