package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 批量处理数据请求参数
 * @author : 萧玄
 * @Date: 18:57 2019/6/27
 */
@ApiModel("批量处理按id数组数据请求参数")
public class BatchEditReqDto<P> {

    @ApiModelProperty(value = "操作人[前端不用传，应用端自动处理并传递给中心微服务]",hidden = true)
    private OperatorReqDto operator;

    @ApiModelProperty(value = "id数组，必填")
    private P[] ids;

    public OperatorReqDto getOperator() {
        return operator;
    }

    public void setOperator(OperatorReqDto operator) {
        this.operator = operator;
    }

    public P[] getIds() {
        return ids;
    }

    public void setIds(P[] ids) {
        this.ids = ids;
    }

    public static <P> BatchEditReqDto getInstance(P[] ids,OperatorReqDto operator){
        BatchEditReqDto<P> batchEditReqDto = new BatchEditReqDto();
        batchEditReqDto.setIds(ids);
        batchEditReqDto.setOperator(operator);
        return batchEditReqDto;
    }
}
