/**
 * @(#)MessageTemplateReqDto.java 1.0 2018年10月23日
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 消息模块查询请求Dto
 * @author zheng.yu
 *
 */
@ApiModel(value = "MessageTemplateReqDto", description = "消息模版查询请求Dto")
public class MessageTemplateReqDto extends RequestDto {

    private static final long serialVersionUID = 4005724884894857389L;
    /**
     * 主键ID
     */
    @ApiModelProperty(name = "id", value = "消息模板编号")
    private Long id;

    /**
     * 模板内容
     */
    @ApiModelProperty(name = "content", value = "模板内容")
    private String content;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;

    /**
     * 实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "实例ID")
    private Long instanceId;

    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;

    /**
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the content
     */
    public String getContent() {
        return content;
    }

    /**
     * @param content the content to set
     */
    public void setContent(String content) {
        this.content = content;
    }

    /**
     * @return the createTime
     */
    public Date getCreateTime() {
        return createTime;
    }

    /**
     * @param createTime the createTime to set
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }
}
