package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 个性化优惠券请求dto
 *
 * @author 浮云
 */
@ApiModel(
        value = "PersonalizedCouponReqDto",
        description = "个性化优惠券请求dto"
)
public class PersonalizedCouponReqDto extends RequestDto {

    @ApiModelProperty(name = "taskId", value = "营销id")
    @NotNull
    private Long taskId;
    @ApiModelProperty(name = "taskType", value = "营销类型 0 画布营销 1主动营销 2 事件营销")
    private Integer taskType;
    @ApiModelProperty(name = "ossUrl", value = "oss文件返回来的地址")
    @NotNull
    private String ossUrl;
    @ApiModelProperty(name = "finishTime", value = "计算完成的时间点,格式是yyyy-MM-dd HH:mm:ss")
    private String finishTime;
    @ApiModelProperty(name = "tenantId", value = "租户id")
    private Long tenantId;
    @ApiModelProperty(name = "instanceId", value = "实例id")
    private Long instanceId;

    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public Integer getTaskType() {
        return taskType;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public String getOssUrl() {
        return ossUrl;
    }

    public void setOssUrl(String ossUrl) {
        this.ossUrl = ossUrl;
    }

    public String getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(String finishTime) {
        this.finishTime = finishTime;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }
}
