package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request;

import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.constants.DtoApiNoteConstants;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.constants.RegexpConstants;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Pattern;
import java.util.List;

@ApiModel(value = "EventQueryReqDto", description = "查询营销任务参数")
public class TaskQueryReqDto extends PagerDto {

    @ApiModelProperty(value = "营销任务名称")
    private String name;

    @ApiModelProperty(value = "营销任务编号")
    private String code;

    @ApiModelProperty(value = "营销任务类型【留空：全部 "+ DtoApiNoteConstants.TASK_TYPE+"】")
    private Integer type;

    @ApiModelProperty(value = "留空:全部 【"+DtoApiNoteConstants.TASK_STATUS+"】")
    private Integer status;

    @ApiModelProperty(value = "状态列表，留空:全部 【"+DtoApiNoteConstants.TASK_STATUS+"】")
    private List<Integer> statusList;

    @Pattern(regexp = RegexpConstants.DATE_TIME_FORMAT_2,message = "时间格式不正确（ yyyy-MM-dd HH:mm:ss或yyyy-MM-dd）")
    @ApiModelProperty(value = "创建开始时间【格式 yyyy-MM-dd HH:mm:ss或者 yyyy-MM-dd】")
    private String beginTime;

    @Pattern(regexp = RegexpConstants.DATE_TIME_FORMAT_2,message = "时间格式不正确（ yyyy-MM-dd HH:mm:ss或yyyy-MM-dd）")
    @ApiModelProperty(value = "创建结束时间【格式 yyyy-MM-dd HH:mm:ss或者 yyyy-MM-dd】")
    private String endTime;

    @ApiModelProperty(value = "更新账号")
    private String updateAccount;

    @ApiModelProperty(value = "启用账号")
    private String enableAccount;

    @ApiModelProperty(value = "券模板编号")
    private String couponCode;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getUpdateAccount() {
        return updateAccount;
    }

    public void setUpdateAccount(String updateAccount) {
        this.updateAccount = updateAccount;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getEnableAccount() {
        return enableAccount;
    }

    public void setEnableAccount(String enableAccount) {
        this.enableAccount = enableAccount;
    }

    public List<Integer> getStatusList() {
        return statusList;
    }

    public void setStatusList(List<Integer> statusList) {
        this.statusList = statusList;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }
}
