package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.task;


import com.dtyunxi.cube.biz.commons.dto.event.MarketingExecReqDto;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.response.task.TaskDetailRespDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.enums.MarketingMethodEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 *
 * @author : 萧玄
 * @Date: 14:28 2019/8/23
 */
@ApiModel(value = "MarketingTaskExecReqDto", description = "营销执行参数")
public class MarketingTaskExecReqDto extends MarketingExecReqDto {

    /**
     * 任务详配置详情
     */
    @ApiModelProperty(name = "taskDetail", value = "任务详配置详情")
    private TaskDetailRespDto taskDetail;

    /**
     * 主动营销实际触发的时间
     */
    @ApiModelProperty(name = "actualTriggerTime", value = "主动营销实际触发的时间")
    private String actualTriggerTime;

    private int pageNum;

    public TaskDetailRespDto getTaskDetail() {
        return taskDetail;
    }

    public void setTaskDetail(TaskDetailRespDto taskDetail) {
        this.taskDetail = taskDetail;
    }

    @Override
    public int getType() {
        return MarketingMethodEnum.INITIATIVE.getKey();
    }

    public int getPageNum() {
        return pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    @Override
    public Long getMarketingTaskId() {
        return taskDetail == null ? super.getMarketingTaskId() : taskDetail.getId();
    }

    public String getActualTriggerTime() {
        return actualTriggerTime;
    }

    public void setActualTriggerTime(String actualTriggerTime) {
        this.actualTriggerTime = actualTriggerTime;
    }

    /**
     * 初始化
     *
     * @param taskDetail
     * @return : com.dtyunxi.yundt.cube.biz.marketing.api.coupon.request.event.MarketingTaskExecReqDto
     * @author : 萧玄
     * @Date : 14:34 2019/8/23
     */
    public static MarketingTaskExecReqDto init(TaskDetailRespDto taskDetail) {
        MarketingTaskExecReqDto marketingTaskExecReqDto = new MarketingTaskExecReqDto();
        marketingTaskExecReqDto.setTaskDetail(taskDetail);
        marketingTaskExecReqDto.setActualTriggerTime(DateUtil.getCurrenDate());
        marketingTaskExecReqDto.setTenantId(taskDetail.getTenantId());
        marketingTaskExecReqDto.setInstanceId(taskDetail.getInstanceId());
        marketingTaskExecReqDto.setExtFields(taskDetail.getExtFields());
        return marketingTaskExecReqDto;
    }

    /**
     * 转化
     *
     * @param marketingTaskTargetCustomerQueryDto
     * @return : com.dtyunxi.yundt.cube.biz.marketing.api.coupon.request.event.MarketingTaskExecReqDto
     * @author : 萧玄
     * @Date : 14:34 2019/8/23
     */
    public static MarketingTaskExecReqDto convert(MarketingTaskTargetCustomerQueryDto marketingTaskTargetCustomerQueryDto) {
        MarketingTaskExecReqDto marketingTaskExecReqDto = new MarketingTaskExecReqDto();
        marketingTaskExecReqDto.setTaskDetail(marketingTaskTargetCustomerQueryDto.getTaskDetail());
        marketingTaskExecReqDto.setActualTriggerTime(marketingTaskTargetCustomerQueryDto.getActualTriggerTime());
        marketingTaskExecReqDto.setExtFields(marketingTaskTargetCustomerQueryDto.getExtFields());
        marketingTaskExecReqDto.setTenantId(marketingTaskTargetCustomerQueryDto.getTenantId());
        marketingTaskExecReqDto.setInstanceId(marketingTaskTargetCustomerQueryDto.getInstanceId());
        return marketingTaskExecReqDto;
    }
}
