package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.task;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;


@ApiModel("推送时间")
public class PushTimeReqDto implements Serializable {

    private static final long serialVersionUID = 5037553171158390003L;
    @ApiModelProperty("时间类型【0：指定时间 1：活动开始前 2：活动结束前 3：每7天循环 4：每月固定第几号循环】")
    private int type;

    @ApiModelProperty(value = "推送日期【pushTime.type=0/3/4时必填，格式：yyyy-MM-dd 】",hidden = true)
    private String pushDate;

    @ApiModelProperty("推送时间点【pushTime.type=1或2时必填，格式为 HH:mm】")
    private String time;

    @ApiModelProperty("活动开始前/结束前X天【pushTime.type=1或2时必填，正整数】")
    private Integer subDay;

    @ApiModelProperty("活动开始时间【pushTime.type=1时必填】")
    private Date activityBeginTime;

    @ApiModelProperty("活动结束时间【pushTime.type=2时必填】")
    private Date activityEndTime;

    @ApiModelProperty("推广时间-选择时间-开始执行时间【pushTime.type=0/3/4时必填，格式：yyyy-MM-dd HH:mm:ss】")
    private Date beginTriggerTime;

    @ApiModelProperty("推广时间-选择时间-终止执行时间【pushTime.type=3或4时必填，格式：yyyy-MM-dd HH:mm:ss】")
    private Date endTriggerTime;

    @ApiModelProperty("每月的几号（pushTime.type=4时候，循环规则选择为每月的时候必填；其余留空）")
    private Integer dayNo;

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getPushDate() {
        //特殊处理：
        return pushDate;
    }

    public void setPushDate(String pushDate) {
        this.pushDate = pushDate;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public Integer getSubDay() {
        return subDay;
    }

    public void setSubDay(Integer subDay) {
        this.subDay = subDay;
    }

    public Date getActivityBeginTime() {
        return activityBeginTime;
    }

    public void setActivityBeginTime(Date activityBeginTime) {
        this.activityBeginTime = activityBeginTime;
    }

    public Date getActivityEndTime() {
        return activityEndTime;
    }

    public void setActivityEndTime(Date activityEndTime) {
        this.activityEndTime = activityEndTime;
    }

    public Integer getDayNo() {
        return dayNo;
    }

    public void setDayNo(Integer dayNo) {
        this.dayNo = dayNo;
    }

    public Date getEndTriggerTime() {
        return endTriggerTime;
    }

    public void setEndTriggerTime(Date endTriggerTime) {
        this.endTriggerTime = endTriggerTime;
    }

    public Date getBeginTriggerTime() {
        return beginTriggerTime;
    }

    public void setBeginTriggerTime(Date beginTriggerTime) {
        this.beginTriggerTime = beginTriggerTime;
    }
}
