package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.response.event;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.constants.DtoApiNoteConstants;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * 事件营销返回参数
 * @author : 萧玄
 * @Date: 16:54 2019/7/4
 */
@ApiModel(value = "EventMarketingAbstractRespDto", description = "事件营销分页列表返回参数")
public class EventMarketingAbstractRespDto extends RequestDto {

    @ApiModelProperty(value = "营销id")
    private Long id;

    @ApiModelProperty(value = "营销编码")
    private String code;

    @ApiModelProperty(value = "营销名称")
    private String name;

    @ApiModelProperty("营销类型【" + DtoApiNoteConstants.MARKETING_TYPE+"】")
    private int marketingType;

    @ApiModelProperty(value = "事件类型【"+ DtoApiNoteConstants.EVENT_STATUS+"】")
    private int eventType;

    @ApiModelProperty(value = "事件名称")
    private String eventName;

    @ApiModelProperty(value = "事件码")
    private String eventCode;

    @ApiModelProperty("事件规则编码")
    private String eventRuleCode;
    @ApiModelProperty("事件规则名称")
    private String eventRuleName;
    @ApiModelProperty("事件规则id")
    private Long eventRuleId;

    @ApiModelProperty(value = "权重")
    private int weight;

    @ApiModelProperty(value = "触达渠道")
    private List<Integer> pushChannels;

    @ApiModelProperty(value = "状态【"+ DtoApiNoteConstants.EVENT_STATUS+"】")
    private int status;

    @ApiModelProperty(value = "更新账号")
    private String updateAccount;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty("启用账号")
    private String enableAccount;

    @ApiModelProperty("截止有效时间")
    private Date endValidTime;

    @ApiModelProperty("初始有效时间")
    private Date firstValidTime;

    @ApiModelProperty("生效时间【初始有效时间+截止有效时间】")
    private String validTime;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty(name = "scene", value = "发券场景：1进店有礼，2下单有礼")
    private Integer scene;

    @ApiModelProperty(name = "theme", value = "主题")
    private String theme;

    public Long getEventRuleId() {
        return eventRuleId;
    }

    public void setEventRuleId(Long eventRuleId) {
        this.eventRuleId = eventRuleId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMarketingType() {
        return marketingType;
    }

    public void setMarketingType(int marketingType) {
        this.marketingType = marketingType;
    }

    public int getEventType() {
        return eventType;
    }

    public void setEventType(int eventType) {
        this.eventType = eventType;
    }

    public String getEventName() {
        return eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getEventCode() {
        return eventCode;
    }

    public void setEventCode(String eventCode) {
        this.eventCode = eventCode;
    }

    public int getWeight() {
        return weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public List<Integer> getPushChannels() {
        return pushChannels;
    }

    public void setPushChannels(List<Integer> pushChannels) {
        this.pushChannels = pushChannels;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getUpdateAccount() {
        return updateAccount;
    }

    public void setUpdateAccount(String updateAccount) {
        this.updateAccount = updateAccount;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getEnableAccount() {
        return enableAccount;
    }

    public void setEnableAccount(String enableAccount) {
        this.enableAccount = enableAccount;
    }

    public Date getEndValidTime() {
        return endValidTime;
    }

    public void setEndValidTime(Date endValidTime) {
        this.endValidTime = endValidTime;
    }

    public Date getFirstValidTime() {
        return firstValidTime;
    }

    public void setFirstValidTime(Date firstValidTime) {
        this.firstValidTime = firstValidTime;
    }

    public String getValidTime() {
        return validTime;
    }

    public void setValidTime(String validTime) {
        this.validTime = validTime;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getEventRuleCode() {
        return eventRuleCode;
    }

    public void setEventRuleCode(String eventRuleCode) {
        this.eventRuleCode = eventRuleCode;
    }

    public String getEventRuleName() {
        return eventRuleName;
    }

    public void setEventRuleName(String eventRuleName) {
        this.eventRuleName = eventRuleName;
    }

    public Integer getScene() {
        return scene;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }

    public String getTheme() {
        return theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }
}
