package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.response.event;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 事件营销触发时间dto
 *
 * @author lan.zifan
 * @date 2019年7月22日14点10分
 */
@ApiModel(value = "EventMarketingExecuteTimeDto", description = "事件营销触发时间dto")
public class EventMarketingExecuteTimeDto {

    @ApiModelProperty(value = "事件营销id")
    private Long id;

    @ApiModelProperty(value = "营销名称")
    private String name;

    @ApiModelProperty(value = "事件码")
    private String eventCode;

    /**
     * 营销时机类型
     * 0：事件触发时（事件发生时立即进行事件营销）
     * 1：事件触发前X天（事件前x天进行）
     * 2：事件触发后X天（事件后x天进行）
     */
    @ApiModelProperty("营销时机类型、（0：事件触发时（立即进行事件营销） 1：事件触发前X天（前x天进行） 2：事件触发后X天（后x天进行））")
    private int type;

    /**
     * 事件触发前后的天数差值（针对type=1或者type=2时)
     * 当type为1时应该减去这个数值
     * 当type为2时应该加上这个数值
     */
    @ApiModelProperty("事件触发前后的天数差值（当type为1时应该减去这个数值，当type为2时应该加上这个数值）")
    private int subDay;

    @ApiModelProperty("触发指定时间点（格式：HH:mm）")
    private String execTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getSubDay() {
        return subDay;
    }

    public void setSubDay(int subDay) {
        this.subDay = subDay;
    }

    public String getExecTime() {
        return execTime;
    }

    public void setExecTime(String execTime) {
        this.execTime = execTime;
    }

    public String getEventCode() {
        return eventCode;
    }

    public void setEventCode(String eventCode) {
        this.eventCode = eventCode;
    }

    @Override
    public String toString() {
        return "EventMarketingExecuteTimeDto{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", eventCode='" + eventCode + '\'' +
                ", type=" + type +
                ", subDay=" + subDay +
                ", execTime='" + execTime + '\'' +
                '}';
    }
}
