package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.response.task;

import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.constants.DtoApiNoteConstants;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.OperatorReqDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.PushChannelDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.task.PushTimeReqDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.task.TargetThrongReqDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.service.IMarketing;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@ApiModel("营销任务详情")
public class TaskDetailRespDto extends OperatorReqDto implements IMarketing, Serializable {

    private static final long serialVersionUID = -2155141190245494981L;
    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("不受营销限制")
    private boolean notLimit;

    @ApiModelProperty("营销类型【" + DtoApiNoteConstants.MARKETING_TYPE+"】")
    private int marketingType;

    @ApiModelProperty("状态【"+ DtoApiNoteConstants.TASK_STATUS+"】")
    private Integer status;

    @ApiModelProperty("营销内容")
    private ContentRespDto content;

    @ApiModelProperty("目标人群")
    private TargetThrongReqDto throng;

    @ApiModelProperty("推送时间")
    private PushTimeReqDto pushTime;

    @ApiModelProperty("触达渠道")
    private List<PushChannelDto> pushChannels;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNotLimit() {
        return notLimit;
    }

    public void setNotLimit(boolean notLimit) {
        this.notLimit = notLimit;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public ContentRespDto getContent() {
        return content;
    }

    public void setContent(ContentRespDto content) {
        this.content = content;
    }

    public TargetThrongReqDto getThrong() {
        return throng;
    }

    public void setThrong(TargetThrongReqDto throng) {
        this.throng = throng;
    }

    public PushTimeReqDto getPushTime() {
        return pushTime;
    }

    public void setPushTime(PushTimeReqDto pushTime) {
        this.pushTime = pushTime;
    }

    @Override
    public List<PushChannelDto> getPushChannels() {
        return pushChannels;
    }

    public void setPushChannels(List<PushChannelDto> pushChannels) {
        this.pushChannels = pushChannels;
    }

    @Override
    public int getMarketingType() {
        return marketingType;
    }

    public void setMarketingType(int marketingType) {
        this.marketingType = marketingType;
    }

    public static TaskDetailRespDto init(){
        TaskDetailRespDto detail = new TaskDetailRespDto();
        detail.setContent(new ContentRespDto());
        detail.setPushChannels(new ArrayList<>());
        detail.setPushTime(new PushTimeReqDto());
        detail.setThrong(new TargetThrongReqDto());
        return detail;
    }
}
