package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.enums;

import com.dtyunxi.cube.biz.commons.enums.IEnum;

import java.util.ArrayList;
import java.util.List;

/**
 * 营销任务状态（0待启用 1待执行 2已禁用 3执行中 4 已完成）
 * @author : 萧玄
 * @Date: 16:23 2019/6/19
 */
public enum MarketingTaskStatusEnum implements IEnum {

    /**
     * 0：待启用
     * @author : 萧玄
     * @Date: 14:18 2019/7/19
     */
    WAITING_ENABLE(0, "待启用"),
    /**
     * 1:待执行
     * @author : 萧玄
     * @Date: 14:18 2019/7/19
     */
    WAITING_EXECUTION(1, "待执行"),
    /**
     * 2:已禁用
     * @author : 萧玄
     * @Date: 14:18 2019/7/19
     */
    DISABLE(2, "已禁用"),
    /**
     * 3:执行中
     * @author : 萧玄
     * @Date: 14:18 2019/7/19
     */
    EXECUTING(3, "执行中"),
    /**
     * 4:已完成
     * @author : 萧玄
     * @Date: 14:18 2019/7/19
     */
    FINISH(4, "已完成"),

    /**
     * 5:异常中断
     * 采集人群线程异常中断、消费完成页异常中断
     */
    EXCEPTION_INTERRUPT(6, "异常中断"),
    ;

    private int key;

    private String value;

    MarketingTaskStatusEnum(int key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int getKey() {
        return key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    @Override
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }


    /**
     * 有效的状态值：已禁用和已完成为无效
     * @author : 萧玄
     * @Date   : 20:14 2019/7/24
     * @param
     * @return : java.util.List<java.lang.Integer>
     */
    public static List<Integer> getEffectiveStatusList(){
        List<Integer> list = new ArrayList<>();
        for(MarketingTaskStatusEnum marketingTaskStatusEnum:MarketingTaskStatusEnum.values()){
            if(MarketingTaskStatusEnum.DISABLE == marketingTaskStatusEnum || MarketingTaskStatusEnum.FINISH == marketingTaskStatusEnum){
                continue;
            }
            list.add(marketingTaskStatusEnum.getKey());
        }
        return list;
    }
}
