package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.enums;

import com.dtyunxi.cube.biz.commons.enums.IEnum;

/**
 * 推送时间类型时间类型(0：指定时间 1：活动开始前 2：活动结束前 3：每7天循环 4：每月固定第几号循环)
 * @author : 萧玄
 * @Date   : 16:45 2019/5/24
 */
public enum PushTimeTypeEnum implements IEnum {

    CERTAIN_TIME(0, "指定时间"),
    BEFORE_ACTIVITY_BEGIN(1, "活动开始前"),
    BEFORE_ACTIVITY_END(2, "活动结束前"),
    EVERY_7_DAY(3, "每7天循环"),
    CERTAIN_DAY_NO(4, "每月固定第几号循环"),
    ;
    private int key;

    private String value;

    PushTimeTypeEnum(int key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int getKey() {
        return key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    @Override
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
