package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.enums.tag;

import org.apache.commons.lang3.StringUtils;

/**
 * 标签比较符枚举
 */
public enum TagCompareEnum {

    eq("=", "等于"),
    ne("!=", "不等于"),
    gt(">", "大于"),
    ge(">=", "大于等于"),
    lt("<", "小于"),
    le("<=", "小于等于"),
    in("in", "在列表"),
    notIn("not in", "不在列表"),
    isNull("is null", "等于空"),
    isNotNull("is not null", "不等于空"),
    like("like", "包含"),
    notLike("no like", "不包含");

    private String code;

    private String desc;

    public static TagCompareEnum getByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (TagCompareEnum tagTypeEnum : TagCompareEnum.values()) {
            if (code.equals(tagTypeEnum.getCode())) {
                return tagTypeEnum;
            }
        }

        return null;
    }

    TagCompareEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static TagCompareEnum negateCompare(TagCompareEnum compare) {
        if (compare == null) {
            return null;
        }
        switch (compare) {
            case eq:
                compare = ne;
                break;
            case ne:
                compare = eq;
                break;
            case gt:
                compare = le;
                break;
            case ge:
                compare = lt;
                break;
            case le:
                compare = gt;
                break;
            case lt:
                compare = ge;
                break;
            case in:
                compare = notIn;
                break;
            case notIn:
                compare = in;
                break;
            case like:
                compare = notLike;
                break;
            case notLike:
                compare = like;
                break;
        }
        return compare;
    }
}
