package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.enums.tag;

import org.apache.commons.lang3.StringUtils;

/**
 * 标签类型枚举
 */
public enum TagTypeEnum {

    BASE_TAG("1", "基础标签"),

    ACTIVITY_TAG("2", "活动标签"),

    LOYALTY_TAG("3", "忠诚度标签");

    private String code;

    private String desc;

    public static TagTypeEnum getByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (TagTypeEnum tagTypeEnum : TagTypeEnum.values()) {
            if (code.equals(tagTypeEnum.getCode())) {
                return tagTypeEnum;
            }
        }

        return null;
    }

    TagTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
