package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.exception;

import com.dtyunxi.cube.commons.exceptions.BizException;

import java.text.MessageFormat;

/**
 * 业务异常
 *
 * @author tuyun
 * @since 2.0.0
 */
public class MarketingBizException extends BizException {

    public MarketingBizException(IExceptionEnum exceptionEnum) {
        super(exceptionEnum.getCode(), exceptionEnum.getMsg());
    }

    public MarketingBizException(IExceptionEnum exceptionEnum,String format) {
        super(exceptionEnum.getCode(), String.format(exceptionEnum.getMsg(),format));
    }

    public MarketingBizException(IExceptionEnum baseErrorEnum, String... args) {
        super(baseErrorEnum.getCode(), MessageFormat.format(baseErrorEnum.getMsg(), args));
    }

    public MarketingBizException(String code, String info) {
        super(code, info);
    }
}
